/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.phisics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.phisics.Air;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.TouchBuf;
import net.comp_lot.craftalos.phisics.TouchConstraint;
import net.comp_lot.craftalos.phisics.TouchTestResult;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.utils.TouchInfo;

public class PhysicsParent {
    public static final double SPEED_RATE = 0.6;
    static final double e = 0.5;
    static final double MIN_LEAVE = 0.005;
    static final double MIN_MOVE = 0.25;
    private static final double g = -0.0075;
    static final double friction = 0.4;
    static final double friction_s = 0.9;
    public static final Vector GRAVITY_FORCE = new MutVector().set(Vector.Y_AXIS).resize(-0.0075);
    private static final double E_SIZE = 0.0025;
    private final List<WorldObject> objectList = new ArrayList<WorldObject>();
    private final List<PhysicsObject> physObjectList = new ArrayList<PhysicsObject>();
    private final EntityParent entities;

    public PhysicsParent(EntityParent entities) {
        this.entities = entities;
    }

    public void compute() {
        this.computeSelfPhysics();
        this.computeTouchList();
        this.computeForce();
        this.computeDamage();
        this.computeMove();
    }

    private void computeDamage() {
        this.physObjectList.parallelStream().flatMap(p -> p.getTouchList().stream()).forEach(touchList -> touchList.stream().forEach(tc -> tc.causeDamage(this.entities)));
    }

    private void computeMove() {
        this.physObjectList.parallelStream().filter(objectA -> objectA.getWeight() != 0).forEach(objectA -> objectA.computeMove());
    }

    private void computeSelfPhysics() {
        this.physObjectList.parallelStream().filter(objectA -> objectA.getWeight() != 0).forEach(objectA -> {
            objectA.computeCenter();
            objectA.calcFixPoint();
            objectA.calcConnectionFunction();
            objectA.addWeightForce(GRAVITY_FORCE);
            new Air((PhysicsObject)objectA).computeAir();
            objectA.computePhisics();
        });
    }

    private void computeTouchList() {
        this.physObjectList.stream().forEach(p -> {
            p.setHasChild(false);
            p.setActiveCalc(null);
            p.clearTouchList();
        });
        this.physObjectList.parallelStream().filter(objectA -> objectA.getWeight() != 0).forEach(objectA -> this.objectList.parallelStream().filter(objectB -> !objectB.isPhysically() || objectA.getWeight() > ((PhysicsObject)objectB).getWeight() || objectA.getWeight() == ((PhysicsObject)objectB).getWeight() && physicsObject.getModel().id < objectB.getModel().id || objectA == objectB && objectA.hasDomesticCollide()).filter(objectB -> !objectB.isPhysically() || ((PhysicsObject)objectB).getWeight() != 0).forEach(objectB -> PhysicsParent.computeTouchList(objectA, objectB)));
    }

    private static void computeTouchList(PhysicsObject objectA, WorldObject objectB) {
        Collection<TouchInfo> list = objectB.getModel().touchTest(objectA.getModel());
        if (!list.isEmpty()) {
            ArrayList<TouchConstraint> list1 = new ArrayList<TouchConstraint>(list.size());
            if (objectA != objectB && objectB.isPhysically()) {
                objectA.meanActive((PhysicsObject)objectB);
                objectA.setHasChild(true);
                ((PhysicsObject)objectB).setActiveCalc(objectA);
                ArrayList<TouchConstraint> list2 = new ArrayList<TouchConstraint>(list.size());
                PhysicsParent.uniq(list).stream().map(ti -> new TouchTestResult((TouchInfo)ti).getTouchConstraint(objectA == objectB)).filter(tc -> tc != null).forEach(tc -> {
                    list1.add(tc.rev());
                    list2.add((TouchConstraint)tc);
                });
                ((PhysicsObject)objectB).addTouchList(list2);
            } else {
                PhysicsParent.uniq(list).stream().map(ti -> new TouchTestResult((TouchInfo)ti).getRevClone().getTouchConstraint(objectA == objectB)).filter(tc -> tc != null).forEach(tc -> {
                    boolean bl = list1.add((TouchConstraint)tc);
                });
            }
            objectA.addTouchList(list1);
        }
    }

    private static Collection<TouchInfo> uniq(Collection<TouchInfo> list) {
        if (list.size() <= 1) {
            return list;
        }
        ArrayList<TouchInfo> uniq = new ArrayList<TouchInfo>(list);
        Collections.sort(uniq, (a, b) -> {
            if (a.getShapeA().getOwner() != b.getShapeA().getOwner()) {
                return Integer.compare(a.getShapeA().getOwner().hashCode(), b.getShapeA().getOwner().hashCode());
            }
            if (a.getShapeB().getOwner() != b.getShapeB().getOwner()) {
                return Integer.compare(a.getShapeB().getOwner().hashCode(), b.getShapeB().getOwner().hashCode());
            }
            return Double.compare(a.getPos().getX() + a.getPos().getY() + a.getPos().getZ(), b.getPos().getX() + b.getPos().getY() + b.getPos().getZ());
        });
        int i = uniq.size() - 1;
        while (i > 0) {
            TouchInfo a2 = (TouchInfo)uniq.get(i);
            TouchInfo b2 = (TouchInfo)uniq.get(i - 1);
            if (a2.getShapeA().getOwner() == b2.getShapeA().getOwner() && a2.getShapeB().getOwner() == b2.getShapeB().getOwner() && !(a2.getPos().getDistS(b2.getPos()) > 0.01) && !(a2.getVec().getDistS(b2.getVec()) > 0.001)) {
                uniq.remove(i);
            }
            --i;
        }
        return uniq;
    }

    private void computeForce() {
        this.physObjectList.parallelStream().filter(objectA -> objectA.getWeight() != 0).forEach(objectA -> objectA.cacheMovement());
        this.physObjectList.parallelStream().filter(objectA -> objectA.getWeight() != 0 && objectA.isActiveCalc()).forEach(objectA -> {
            Bool b = new Bool();
            int num = 0;
            do {
                b.set(false);
                this.computeForce((PhysicsObject)objectA, b, num++);
            } while (b.value());
        });
    }

    private void computeForce(PhysicsObject objectA, Bool b, int i) {
        objectA.getTouchList().parallelStream().map(touchList -> PhysicsParent.getMaxTouch(touchList, i)).filter(max -> max.isPresent()).forEach(max -> {
            b.set(true);
            ((TouchBuf)max.get()).couputeForce(i);
        });
        this.conputeAccelaration(objectA);
        if (objectA.hasChild()) {
            this.physObjectList.stream().filter(objectB -> objectB.isLeader(objectA)).forEach(objectB -> {
                this.conputeAccelaration((PhysicsObject)objectB);
                this.computeForce((PhysicsObject)objectB, b, i);
            });
            this.conputeAccelaration(objectA);
        }
    }

    private void conputeAccelaration(PhysicsObject objectA) {
        objectA.getTouchList().stream().flatMap(tl -> tl.stream()).forEach(tc -> tc.addForce());
        objectA.computePhisics();
    }

    private static Optional<TouchBuf> getMaxTouch(List<TouchConstraint> touchList, int i) {
        return touchList.parallelStream().map(tc -> {
            if (!Double.isFinite(tc.dvObjective)) {
                System.err.println("dvObjective is " + tc.dvObjective);
                return null;
            }
            MutVector relative = tc.getNewRelative();
            double dv = tc.dvObjective - Vector.Dot(relative, tc.vec);
            if (PhysicsParent.abs(dv) < 0.0025 * (double)(5 + i)) {
                return null;
            }
            return new TouchBuf((TouchConstraint)tc, dv, relative);
        }).filter(tb -> tb != null).max((a, b) -> Double.compare(PhysicsParent.abs(a.getDv()), PhysicsParent.abs(b.getDv())));
    }

    public void addObject(WorldObject ... object) {
        WorldObject[] worldObjectArray = object;
        int n = object.length;
        int n2 = 0;
        while (n2 < n) {
            WorldObject o = worldObjectArray[n2];
            if (o.isPhysically()) {
                PhysicsObject p = (PhysicsObject)o;
                p.computeCenter();
                p.calcFixPoint();
                p.calcConnectionFunction();
                p.computePhisics();
                this.physObjectList.add(p);
            }
            this.objectList.add(o);
            ++n2;
        }
    }

    public void removeObject(PhysicsObject ... object) {
        PhysicsObject[] physicsObjectArray = object;
        int n = object.length;
        int n2 = 0;
        while (n2 < n) {
            PhysicsObject o = physicsObjectArray[n2];
            this.objectList.remove(o);
            this.physObjectList.remove(o);
            ++n2;
        }
    }

    public Collection<WorldObject> getObjects() {
        return this.objectList;
    }

    private static double abs(double a) {
        return a > 0.0 ? a : -a;
    }

    private static class Bool {
        private boolean b;

        private Bool() {
        }

        void set(boolean b) {
            this.b = b;
        }

        boolean value() {
            return this.b;
        }
    }
}

