/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.phisics;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.game.model.AbstractMotorBlock;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.phisics.Connection;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.craftalos.phisics.Movement;
import net.comp_lot.craftalos.phisics.PhysicsProperty;
import net.comp_lot.craftalos.phisics.Torque;
import net.comp_lot.craftalos.phisics.TouchConstraint;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;

public abstract class PhysicsObject
extends WorldObject
implements PhysicsProperty {
    private static final Connection DIRECT_CONNECTION = new Connection(){

        @Override
        public void keepConnection() {
        }

        @Override
        public void calcFixPoint() {
        }

        @Override
        public void calcFunction() {
        }

        @Override
        public void calcParentFixPoint() {
        }
    };
    private Connection connection = DIRECT_CONNECTION;
    private final List<PhysicsObject> children = new ArrayList<PhysicsObject>();
    private double active = 0.0;
    private boolean hasChild = false;
    private PhysicsObject leader = null;
    private final List<List<TouchConstraint>> touchList = new ArrayList<List<TouchConstraint>>();
    private final Movement movementG = new Movement();
    private final Movement movementBufG = new Movement();
    private final Movement fullMovementG = new Movement();
    private final Movement fullMovementBufG = new Movement();
    private final List<Force> forceListG = new ArrayList<Force>();
    private final List<MutVector> torqueListG = new ArrayList<MutVector>();

    public PhysicsObject(ModelGroup model) {
        super(model);
    }

    protected void addChild(PhysicsObject o) {
        this.children.add(o);
        ((ModelGroup)this.getModel()).addModels(o.getModel());
    }

    protected void removeChild(PhysicsObject o) {
        this.children.remove(o);
        ((ModelGroup)this.getModel()).removeModel(o.getModel());
    }

    public List<PhysicsObject> getChildren() {
        return this.children;
    }

    public abstract int getSingleWeight();

    public abstract Vector getSingleCenter();

    public final double getMoment(Vector center, Vector direction) {
        Vector dire = direction.getSize() == 1.0 ? direction : new MutVector().set(direction).resize(1.0);
        double moment = this.getMomentSub(center, dire);
        if (this.connection instanceof AbstractMotorBlock) {
            moment += ((AbstractMotorBlock)this.connection).getInternalMoment();
        }
        return moment;
    }

    private final double getMomentSub(Vector center, Vector direction) {
        MutVector r = new MutVector().set(this.getCenter(), center).toOrthogonal(direction);
        return Vector.Dot(direction, this.getTensor().fromRight(direction)) + (double)this.getWeight() * r.getSize() * r.getSize();
    }

    private Vector getMomentCenter() {
        if (this.connection instanceof AbstractMotorBlock) {
            return ((AbstractMotorBlock)this.connection).getConnectionPoint();
        }
        return this.getCenter();
    }

    public final double getFakeWeight(Force force) {
        if (this.getParent() != null) {
            double cmt;
            double pm;
            Connection.SplitedTorqueForce sf = this.connection.splitForce(force);
            double d = pm = sf.pForce == null ? 0.0 : ((PhysicsObject)this.getParent()).getFakeWeight(sf.pForce);
            double cm = sf.cForce == null ? 0.0 : (sf.cTorque == null ? this.getFakeWeightSub(sf.cForce) : (double)this.getWeight());
            double d2 = cmt = sf.cTorque == null ? 0.0 : this.getFakeWeightByTorque(sf.cTorque, force.getPoint());
            if (cm != 0.0 && cmt != 0.0) {
                cm = cm * cmt / (cm + cmt);
            } else if (cmt != 0.0) {
                cm = cmt;
            }
            if (pm == 0.0 && cm == 0.0) {
                System.err.println("Weight is 0");
            }
            if (pm == 0.0) {
                return cm;
            }
            if (cm == 0.0) {
                return pm;
            }
            double m = pm * cm / (pm + cm);
            if (m < 0.0) {
                throw new RuntimeException();
            }
            return m;
        }
        return this.getFakeWeightSub(force);
    }

    private double getFakeWeightSub(Force force) {
        if (force.getForce().getSize() == 0.0) {
            return this.getWeight();
        }
        MutVector r = new MutVector().set(this.getMomentCenter(), force.getPoint());
        MutVector f = new MutVector().set(force.getForce()).resize(1.0);
        MutVector rf = MutVector.Cross(r, f);
        double m = this.getWeight();
        double I = this.getMoment(this.getMomentCenter(), rf);
        return m * I / (I + m * r.getSize() * rf.getSize());
    }

    private double getFakeWeightByTorque(Vector torque, Vector pos) {
        MutVector r = new MutVector().set(this.getMomentCenter(), pos).toOrthogonal(torque);
        double I = this.getMoment(this.getMomentCenter(), torque);
        return I / (torque.getSize() * r.getSize());
    }

    public String getConnectionIdent() {
        if (this.connection instanceof ConnectionBlock) {
            return ((ConnectionBlock)this.connection).getIdent();
        }
        return null;
    }

    public void setConnection(Connection c) {
        this.connection = c;
        this.active = -1.0;
    }

    public void stopMotion() {
        this.movementG.reset();
        this.movementBufG.reset();
        this.fullMovementG.reset();
        this.fullMovementBufG.reset();
        this.forceListG.clear();
        this.torqueListG.clear();
        this.children.parallelStream().forEach(c -> c.stopMotion());
    }

    public void addForce(Force f) {
        if (!(f.getForce().getSize() > 0.0)) {
            return;
        }
        if (this.getParent() != null) {
            if (f.getCache() == null) {
                f.setCache(this.connection.splitForce(f));
            }
            this.addSplitedTorqueForce((PhysicsObject)this.getParent(), f.getCache());
        } else {
            this.addForceSub(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addForceSub(Force f) {
        List<Force> list = this.forceListG;
        synchronized (list) {
            this.forceListG.add(f);
        }
    }

    public void addTorque(Torque t) {
        if (!(t.getTorque().getSize() > 0.0)) {
            return;
        }
        if (this.getParent() != null) {
            if (t.getCache() == null) {
                t.setCache(this.connection.splitTorque(t));
            }
            this.addSplitedTorqueForce((PhysicsObject)this.getParent(), t.getCache());
        } else {
            this.addTorqueSub(t.getTorque());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTorqueSub(MutVector t) {
        List<MutVector> list = this.torqueListG;
        synchronized (list) {
            this.torqueListG.add(t);
        }
    }

    private void addSplitedTorqueForce(PhysicsObject parent, Connection.SplitedTorqueForce stf) {
        if (stf.pForce != null) {
            parent.addForce(stf.pForce);
        }
        if (stf.cForce != null) {
            this.addForceSub(stf.cForce);
        }
        if (stf.pTorque != null) {
            parent.addTorque(stf.pTorque);
        }
        if (stf.cTorque != null) {
            this.addTorqueSub(stf.cTorque);
        }
    }

    public void addWeightForce(Vector f) {
        if (this.getSingleWeight() > 0) {
            MutVector wf = new MutVector().set(f).scale(this.getSingleWeight());
            this.addForce(new Force(new MutVector().set(this.getSingleCenter()), wf));
        }
        this.children.stream().forEach(c -> c.addWeightForce(f));
    }

    public void setMoveBuf(Vector move) {
        this.movementBufG.setMove(move);
    }

    public MutVector getMoveBuf(MutVector dst) {
        return dst.set(this.movementBufG.getMove());
    }

    public void setRotationBuf(Vector rotation) {
        this.movementBufG.setRotate(rotation);
    }

    public Vector getRotationBuf() {
        return this.movementBufG.getRotate();
    }

    void calcFixPoint() {
        this.children.stream().forEach(c -> c.calcFixPoint());
        this.connection.calcFixPoint();
    }

    protected void computePhisics() {
        if (this.getWeight() <= 0) {
            this.forceListG.clear();
            this.torqueListG.clear();
        }
        this.movementBufG.set(this.movementG);
        MutVector force = null;
        MutVector torque = null;
        if (!this.forceListG.isEmpty()) {
            MutVector buf = new MutVector();
            force = new MutVector();
            torque = new MutVector();
            for (Force f : this.forceListG) {
                force.add(f.getForce());
                buf.set(this.getCenter(), f.getPoint());
                torque.add(MutVector.Cross(buf, f.getForce()));
            }
            this.forceListG.clear();
        }
        if (!this.torqueListG.isEmpty()) {
            if (torque == null) {
                torque = new MutVector();
            }
            this.torqueListG.stream().reduce(torque, (a, b) -> a.add((Vector)b));
            this.torqueListG.clear();
        }
        if (force != null && force.getSize() > 0.0) {
            this.movementBufG.acclMove(force.scale(1.0 / (double)this.getWeight()));
        }
        if (torque != null && torque.getSize() > 0.0) {
            this.movementBufG.acclRotate(torque.scale(1.0 / this.getMoment(this.getMomentCenter(), torque)));
        }
        this.connection.keepConnection();
        if (this.getParent() == null) {
            this.fullMovementBufG.set(this.movementBufG);
        } else {
            this.fullMovementBufG.setMove(this.getParent().getNewMove(this.getCenter()));
            this.fullMovementBufG.setRotate(((PhysicsObject)this.getParent()).fullMovementBufG.getRotate());
            this.fullMovementBufG.accl(this.movementBufG);
        }
        this.children.stream().forEach(c -> c.computePhisics());
    }

    void calcConnectionFunction() {
        this.children.stream().forEach(c -> c.calcConnectionFunction());
        this.connection.calcFunction();
    }

    protected void computeMove() {
        if (this.getWeight() <= 0) {
            return;
        }
        this.movementG.set(this.movementBufG);
        if (this.getParent() == null) {
            this.fullMovementG.set(this.movementBufG);
        } else {
            this.fullMovementG.set(this.fullMovementBufG);
        }
        this.children.parallelStream().forEach(c -> c.computeMove());
        this.updateActive();
        if (this.active < 0.0 || this.active > 0.5) {
            MutVector buf = new MutVector();
            this.getModel().GlobalToLocal(buf, this.movementG.getMove());
            this.getModel().moveL(buf, 0.6);
            MutVector gcl = new MutVector();
            this.getModel().GlobalToLocalCoord(gcl, this.getCenter());
            this.getModel().GlobalToLocal(buf, this.movementG.getRotate());
            this.getModel().rotateL(gcl, buf, buf.getSize() * 0.6);
        } else {
            this.stopMotion();
        }
    }

    void cacheMovement() {
        this.movementG.set(this.movementBufG);
        this.children.parallelStream().forEach(c -> c.cacheMovement());
    }

    private void updateActive() {
        this.addActive(this.movementG.calcActiveScore());
        if (this.active >= 0.0) {
            if (this.active > 50.0) {
                this.active = 50.0;
            }
            if (this.active > 0.0) {
                this.active = this.active * 0.85 - 0.75;
            }
            if (this.active < 0.0) {
                this.active = 0.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void meanActive(PhysicsObject objectB) {
        PhysicsObject physicsObject = this;
        synchronized (physicsObject) {
            PhysicsObject physicsObject2 = objectB;
            synchronized (physicsObject2) {
                int meanActive = (int)((this.active + objectB.active) / 2.0);
                this.active = meanActive;
                objectB.active = meanActive;
            }
        }
    }

    private synchronized void addActive(double a) {
        if (this.active >= 0.0) {
            this.active += a;
        } else {
            ((PhysicsObject)this.getParent()).addActive(a * 0.75);
        }
    }

    public void setActive(double active) {
        this.active = active;
    }

    @Override
    public MutVector getMove(Vector c) {
        return this.getSelfMove(c, this.fullMovementG);
    }

    MutVector getMoveWithoutRotation(Vector pos) {
        return this.addParentMove(pos, false, new MutVector().set(this.movementG.getMove()));
    }

    @Override
    public MutVector getNewMove(Vector c) {
        return this.getSelfMove(c, this.fullMovementBufG);
    }

    private MutVector getSelfMove(Vector pointG, Movement movG) {
        MutVector buf = new MutVector().set(this.getCenter(), pointG);
        MutVector bufMove = MutVector.Cross(movG.getRotate(), buf);
        bufMove.add(movG.getMove());
        return bufMove;
    }

    private MutVector addParentMove(Vector pointG, boolean n, MutVector bufMove) {
        if (this.getParent() != null) {
            Vector parentMove = n ? this.getParent().getNewMove(pointG) : this.getParent().getMove(pointG);
            bufMove.add(parentMove);
        }
        return bufMove;
    }

    public void clear() {
        this.children.clear();
        ((ModelGroup)this.getModel()).clearChildren();
    }

    public static Matrix getBoxTensor(double x, double y, double z, double m) {
        return new Matrix((y * y + z * z) * m / 12.0, 0.0, 0.0, 0.0, (z * z + x * x) * m / 12.0, 0.0, 0.0, 0.0, (x * x + y * y) * m / 12.0);
    }

    public static Matrix getOffsetTensor(Vector r, double m) {
        return new Matrix(m * (r.getY() * r.getY() + r.getZ() * r.getZ()), -m * r.getX() * r.getY(), -m * r.getX() * r.getZ(), -m * r.getY() * r.getX(), m * (r.getX() * r.getX() + r.getZ() * r.getZ()), -m * r.getY() * r.getZ(), -m * r.getZ() * r.getX(), -m * r.getZ() * r.getY(), m * (r.getX() * r.getX() + r.getY() * r.getY()));
    }

    public void clearTouchList() {
        this.touchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTouchList(List<TouchConstraint> list) {
        List<List<TouchConstraint>> list2 = this.touchList;
        synchronized (list2) {
            this.touchList.add(list);
        }
    }

    public List<List<TouchConstraint>> getTouchList() {
        return this.touchList;
    }

    public boolean isActiveCalc() {
        return this.leader == null;
    }

    public boolean isLeader(PhysicsObject leader) {
        return this.leader == leader;
    }

    public void setActiveCalc(PhysicsObject leader) {
        this.leader = leader;
    }

    public boolean hasChild() {
        return this.hasChild;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }
}

