/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.phisics;

import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;

public class Movement {
    private static final double MIN_MOVE = 0.009;
    private static final double MIN_ROTATION = 0.0045;
    private final MutVector move = new MutVector();
    private final MutVector rotate = new MutVector();

    public Movement() {
        this.reset();
    }

    public void reset() {
        this.setMove(Vector.ZERO);
        this.setRotate(Vector.ZERO);
    }

    public void set(Movement m) {
        this.setMove(m.getMove());
        this.setRotate(m.getRotate());
    }

    public Vector getMove() {
        return this.move;
    }

    public void setMove(Vector move) {
        this.move.set(move);
    }

    public Vector getRotate() {
        return this.rotate;
    }

    public void setRotate(Vector rotate) {
        this.rotate.set(rotate);
    }

    public void accl(Movement accl) {
        this.acclMove(accl.getMove());
        this.acclRotate(accl.getRotate());
    }

    public void acclMove(Vector accl) {
        this.move.add(accl);
    }

    public void acclRotate(Vector accl) {
        this.rotate.add(accl);
    }

    double calcActiveScore() {
        double a = (this.getMove().getSize() + Math.abs(Vector.Dot(Vector.Y_AXIS, this.getMove()))) / 0.009 + (this.getRotate().getSize() * 1.5 - Math.abs(Vector.Dot(Vector.Y_AXIS, this.getRotate()))) / 0.0045;
        if (a >= 0.0) {
            return a;
        }
        System.err.println("active score = " + a);
        return 0.0;
    }
}

