/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.phisics;

import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;

public class CalculatingForce {
    private final Vector vec;
    private boolean enable = false;
    private final MutVector force = new MutVector();
    private final MutVector rForce = new MutVector();
    private final MutVector nForce = new MutVector();
    private final MutVector fForce = new MutVector();
    private Force forceCache;
    private Force rForceCache;

    public CalculatingForce(Vector vec) {
        this.vec = vec;
    }

    public Force getForce(Vector pos) {
        if (this.forceCache == null) {
            this.forceCache = new Force(pos, this.force);
        }
        return this.forceCache;
    }

    public Force getRevForce(Vector pos) {
        if (this.rForceCache == null) {
            this.rForceCache = new Force(pos, this.rForce);
        }
        return this.rForceCache;
    }

    public Vector getNormalForce() {
        return this.nForce;
    }

    public void addForce(Vector nForce, Vector fForce, double friction, boolean rev) {
        if (rev) {
            this.nForce.add(nForce, -1.0);
            this.fForce.add(fForce, -1.0);
        } else {
            this.nForce.add(nForce);
            this.fForce.add(fForce);
        }
        this.updateForce(friction);
    }

    public boolean isEnable() {
        return this.enable;
    }

    private void updateForce(double friction) {
        if (Vector.Dot(this.nForce, this.vec) <= 0.0) {
            this.nForce.set(Vector.ZERO);
            this.fForce.set(Vector.ZERO);
            this.enable = false;
        } else {
            if (this.fForce.getSize() > this.nForce.getSize() * friction) {
                this.fForce.resize(this.nForce.getSize() * friction);
            }
            this.force.set(this.nForce).add(this.fForce);
            this.rForce.set(this.force).reverse();
            this.enable = true;
        }
        this.forceCache = null;
        this.rForceCache = null;
    }
}

