/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.phisics;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.utils.RayCast;

public class Air {
    private static final AtomicLong SEED = new AtomicLong();
    private final PhysicsObject o;
    private final int repeat;
    private final double unitAngle;
    private final double k;
    private final double k2;
    private final double k3;
    private final double size;

    public Air(PhysicsObject o) {
        this.o = o;
        this.size = o.getModel().getBound().getSize();
        this.repeat = Math.min((int)(10.0 + this.size * 1.5), 50);
        this.unitAngle = Math.PI * 6 / (double)this.repeat;
        double unit = this.size * this.size / (double)this.repeat;
        this.k = -0.019 * unit;
        this.k2 = -0.0014 * unit;
        this.k3 = -1.0E-4 * unit;
    }

    public void computeAir() {
        Vector z;
        Vector x;
        Vector y = Vector.Y_AXIS;
        MutVector tx = this.o.getMove(this.o.getCenter());
        tx.set(tx.getX(), 0.0, tx.getZ());
        if (tx.getSize() < 0.25) {
            x = Vector.X_AXIS;
            z = Vector.Z_AXIS;
        } else {
            x = tx.resize(1.0);
            z = MutVector.Cross(x, y);
        }
        Vector c = this.o.getModel().getBound().getCenter();
        long seed = SEED.getAndAdd(6L);
        ((Stream)Arrays.stream(new Runnable[]{() -> this.repeatComputeForce(this.o.getModel(), c, x, y, z, seed), () -> this.repeatComputeForce(this.o.getModel(), c, new MutVector().set(x).reverse(), y, z, seed + 1L), () -> this.repeatComputeForce(this.o.getModel(), c, y, x, z, seed + 2L), () -> this.repeatComputeForce(this.o.getModel(), c, new MutVector().set(y).reverse(), x, z, seed + 3L), () -> this.repeatComputeForce(this.o.getModel(), c, z, y, x, seed + 4L), () -> this.repeatComputeForce(this.o.getModel(), c, new MutVector().set(z).reverse(), y, x, seed + 5L)}).parallel()).forEach(r -> r.run());
    }

    private void repeatComputeForce(Model m, Vector c, Vector v1, Vector v2, Vector v3, long seed) {
        Random random = new Random(seed);
        int i = 0;
        while (i < this.repeat) {
            this.couputeForce(m, c, v1, v2, v3, i, random);
            ++i;
        }
    }

    private void couputeForce(Model m, Vector c, Vector v1, Vector v2, Vector v3, int i, Random random) {
        double r = this.size * Math.sqrt(random.nextDouble());
        double a = ((double)i + random.nextDouble()) * this.unitAngle;
        double d = Math.sqrt(this.size * this.size - r * r);
        MutVector vec = new MutVector().set(c).add(v1, -d).add(v2, r * Math.sin(a)).add(v3, r * Math.cos(a));
        RayCast cast = new RayCast(vec, v1, d * 2.0);
        RayCast.CastResult cr = cast.cast(m);
        if (cr != null) {
            MutVector n;
            PhysicsObject o = (PhysicsObject)cr.shape.getOwner();
            MutVector v = o.getMove(cr.point);
            double dot = Vector.Dot(v, n = vec.set(cr.getNormal())) / ((Vector)v).getSize();
            if (dot < 0.0) {
                n.reverse();
                dot = -dot;
            }
            n.resize(this.resistFunc(((Vector)v).getSize(), dot));
            n.add(v, ((Vector)v).getSize() * ((Vector)v).getSize() * this.k3);
            o.addForce(new Force(cr.point, n));
        }
    }

    private double resistFunc(double v, double dot) {
        return ((v - 1.25) / (1.0 + Math.abs(v - 1.25)) + 0.556) * v * (1.0 - dot * dot) * this.k + v * v * v * v * dot * this.k2;
    }
}

