/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.mission;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.comp_lot.craftalos.mission.Mission;
import net.comp_lot.craftalos.mission.MissionBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MissionXMLHandler
extends DefaultHandler {
    private List<Mission> missions;
    private MissionBuilder missionBuilder;
    private Consumer<String> charactersListener;

    MissionXMLHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        switch (qName) {
            case "missions": {
                this.missions = new ArrayList<Mission>();
                break;
            }
            case "mission": {
                this.missionBuilder = new MissionBuilder();
                this.missionBuilder.setMissionID(attr.getValue("id"));
                this.missionBuilder.setPlace(attr.getValue("x"), attr.getValue("y"));
                break;
            }
            case "title": {
                this.charactersListener = s -> this.missionBuilder.setTitle((String)s);
                break;
            }
            case "place": {
                this.charactersListener = s -> this.missionBuilder.setPlace((String)s);
                break;
            }
            case "description": {
                this.charactersListener = s -> this.missionBuilder.setDescription((String)s);
                break;
            }
            case "model": {
                this.charactersListener = s -> this.missionBuilder.setMapModel((String)s);
                break;
            }
            case "program": {
                this.charactersListener = s -> this.missionBuilder.setMapProgram((String)s);
                break;
            }
            case "machine": {
                this.charactersListener = s -> this.missionBuilder.setMachine((String)s);
                break;
            }
            case "tutorial": {
                this.charactersListener = s -> this.missionBuilder.setTutorial(Boolean.parseBoolean(s));
                break;
            }
            case "premise": {
                this.missionBuilder.addPremise(attr.getValue("id"));
                break;
            }
            case "reward": {
                this.charactersListener = s -> this.missionBuilder.addReward((String)s);
                break;
            }
            default: {
                throw new SAXException(String.format("tag \"%s\" is undefined", qName));
            }
            case "premises": 
            case "map": 
            case "rewards": 
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String t = new String(ch, start, length).trim();
        if (t.length() > 0) {
            StringBuilder sb = new StringBuilder();
            t.lines().map(line -> line.trim()).forEach(line -> {
                sb.append((String)line);
                sb.append("\n");
            });
            this.charactersListener.accept(sb.toString().trim());
            this.charactersListener = null;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("mission")) {
            this.missions.add(this.missionBuilder.build());
            this.missionBuilder = null;
        }
    }

    public List<Mission> getMissions() {
        return this.missions;
    }
}

