/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.mission;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.comp_lot.craftalos.mission.Mission;
import net.comp_lot.craftalos.mission.MissionXMLHandler;
import net.comp_lot.glui.system.utils.FileUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MissionData {
    private static final Map<String, Mission> MISSION_MAP = new LinkedHashMap<String, Mission>();

    static {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            MissionXMLHandler handler = new MissionXMLHandler();
            parser.parse((InputStream)new ByteArrayInputStream(FileUtils.loadFile("res/missions.xml").getBytes("utf-8")), (DefaultHandler)handler);
            handler.getMissions().stream().forEach(m -> {
                Mission mission = MISSION_MAP.put(m.getMissionID(), (Mission)m);
            });
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.err.println("[MissionData] : " + e.getLocalizedMessage());
        }
        MissionData.load();
    }

    public static Stream<Mission> getMissions() {
        return MISSION_MAP.values().stream().filter(m -> m.isPremiseAcceptable());
    }

    public static Optional<Mission> getMission(String missionID) {
        return Optional.ofNullable(MISSION_MAP.getOrDefault(missionID, null));
    }

    public static int getCompletePercent() {
        return (int)(100L * MISSION_MAP.values().stream().filter(m -> m.isClear()).count() / (long)MISSION_MAP.size());
    }

    public static boolean isTutorialRemains() {
        return MISSION_MAP.values().stream().anyMatch(m -> m.isPremiseAcceptable() && m.isTutorial() && !m.isClear());
    }

    public static void save() {
        StringBuilder sb = new StringBuilder();
        MISSION_MAP.values().stream().filter(m -> m.isClear()).forEach(m -> {
            sb.append(m.getMissionID());
            sb.append(":");
            sb.append(m.getState().name().substring(6, 7));
            sb.append('\n');
        });
        FileUtils.writeFile("save.txt", sb.toString());
    }

    private static void load() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (Scanner scan = new Scanner(FileUtils.loadFile("save.txt"));){
                while (scan.hasNextLine()) {
                    String line = scan.nextLine();
                    String id = line.replaceAll("([A-Z]+):?([A-Z]?)", "$1");
                    String rank = line.replaceAll("([A-Z]+):?([A-Z]?)", "$2");
                    if (rank.isEmpty()) {
                        rank = "UNRANKED";
                    }
                    Mission.MissionState state = Mission.MissionState.valueOf("CLEAR_" + rank);
                    MissionData.getMission(id).ifPresent(m -> m.setState(state));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static Collection<String> getRewards() {
        HashSet<String> rewards = new HashSet<String>();
        MISSION_MAP.values().stream().filter(m -> m.isClear()).forEach(m -> m.getRewards().forEach(r -> {
            boolean bl = rewards.add((String)r);
        }));
        return rewards;
    }
}

