/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.mission;

import java.util.ArrayList;
import java.util.List;
import net.comp_lot.craftalos.mission.Mission;

class MissionBuilder {
    private String missionID = null;
    private String title = "UNKNOWN";
    private String place = "UNKNOWN";
    private String description = "UNKNOWN";
    private String mapModel = null;
    private String mapProgram = null;
    private String machine = null;
    private boolean isTutorial = false;
    private final List<String> premises = new ArrayList<String>();
    private final List<String> rewards = new ArrayList<String>();
    private int x = 1;
    private int y = 1;

    MissionBuilder() {
    }

    public Mission build() throws IllegalArgumentException {
        if (this.missionID == null || this.mapModel == null) {
            throw new IllegalArgumentException("[MissionBuilder] ID and mapModel is required");
        }
        return new Mission(this.missionID, this.title, this.place, this.description, (String)(this.mapProgram == null ? this.mapModel : this.mapModel + ":" + this.mapProgram), this.machine, this.isTutorial, this.premises, this.rewards, this.x, this.y);
    }

    public void setMissionID(String missionID) {
        this.missionID = missionID;
    }

    public void setPlace(String x, String y) {
        this.x = Integer.parseInt(x);
        this.y = Integer.parseInt(y);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMapModel(String mapModel) {
        this.mapModel = mapModel;
    }

    public void setMapProgram(String mapProgram) {
        this.mapProgram = mapProgram;
    }

    public void setMachine(String machine) {
        this.machine = machine;
    }

    public void setTutorial(boolean isTutorial) {
        this.isTutorial = isTutorial;
    }

    public void addPremise(String premise) {
        this.premises.add(premise);
    }

    public void addReward(String reward) {
        this.rewards.add(reward);
    }
}

