/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.mission;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.comp_lot.craftalos.mission.MissionData;

public class Mission {
    private final String title;
    private final String mapName;
    private final String description;
    private final String missionID;
    private final String mapID;
    private final String machine;
    private final boolean isTutorial;
    private final int x;
    private final int y;
    private MissionState state = MissionState.NOT_CLEAR;
    private final Set<String> premiseMissions = new HashSet<String>();
    private final Set<String> rewards = new HashSet<String>();

    public Mission(String missionID, String title, String mapName, String description, String mapID, String machine, boolean isTutorial, Collection<String> premiseMissions, Collection<String> rewards, int x, int y) {
        this.missionID = missionID;
        this.title = title;
        this.mapName = mapName;
        this.description = description;
        this.mapID = mapID;
        this.machine = machine;
        this.isTutorial = isTutorial;
        this.premiseMissions.addAll(premiseMissions);
        this.rewards.addAll(rewards);
        this.x = x;
        this.y = y;
    }

    public String getMissionID() {
        return this.missionID;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMapID() {
        return this.mapID;
    }

    public String getMachine() {
        return this.machine;
    }

    public boolean isTutorial() {
        return this.isTutorial;
    }

    public Stream<String> getRewards() {
        return this.rewards.stream();
    }

    public void setState(MissionState state) {
        this.state = state;
    }

    public MissionState getState() {
        return this.state;
    }

    public boolean updateState(MissionState state) {
        if (state.ordinal() < this.state.ordinal()) {
            this.state = state;
            return true;
        }
        return false;
    }

    public boolean isClear() {
        return this.state != MissionState.NOT_CLEAR;
    }

    public boolean isPremiseAcceptable() {
        return !this.premiseMissions.stream().anyMatch(m -> MissionData.getMission(m).map(mission -> mission.isClear()).orElse(false) == false);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static enum MissionState {
        CLEAR_S,
        CLEAR_A,
        CLEAR_B,
        CLEAR_C,
        CLEAR_D,
        CLEAR_UNRANKED,
        NOT_CLEAR;

    }
}

