/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map.map;

import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.model.TextGroup;

public class TutorialMap
implements MapBuilder {
    private static final int BLOCK_SIZE = 72;
    private static final Vector FIRST_PLACE = new MutVector().set(72.0, 76.0, 0.0);

    @Override
    public Vector getFirstPlace() {
        return FIRST_PLACE;
    }

    @Override
    public WorldObject make() {
        ModelGroup base = new ModelGroup();
        ModelGroup street = new ModelGroup();
        BoxShape box = TutorialMap.makeBlock(0.0, 0.0, 20.0, 3.0, 1.0, ColorEnum.MAP_GREEN.getRgba());
        TutorialMap.move(box, -1.0, -1.0);
        street.addModels(box);
        box = TutorialMap.makeBlock(0.0, 0.0, 20.0, 3.0, 1.0, ColorEnum.MAP_GREEN.getRgba());
        TutorialMap.move(box, -21.0, -1.0);
        street.addModels(box);
        base.addModels(street);
        ModelGroup stage = TutorialMap.stage01();
        TutorialMap.move(stage, 0.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage02();
        TutorialMap.move(stage, 4.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage03();
        TutorialMap.move(stage, 8.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage04();
        TutorialMap.move(stage, 12.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage05();
        TutorialMap.move(stage, 16.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage06();
        TutorialMap.move(stage, 0.0, -6.0);
        base.addModels(stage);
        stage = TutorialMap.stage07();
        TutorialMap.move(stage, 4.0, -6.0);
        base.addModels(stage);
        stage = TutorialMap.stage08();
        TutorialMap.move(stage, 8.0, -6.0);
        base.addModels(stage);
        stage = TutorialMap.stage09();
        TutorialMap.move(stage, 12.0, -6.0);
        base.addModels(stage);
        stage = TutorialMap.stage10();
        TutorialMap.move(stage, 16.0, -6.0);
        base.addModels(stage);
        stage = TutorialMap.stage11();
        TutorialMap.move(stage, -5.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage12();
        TutorialMap.move(stage, -9.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage13();
        TutorialMap.move(stage, -13.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage14();
        TutorialMap.move(stage, -17.0, 2.0);
        base.addModels(stage);
        stage = TutorialMap.stage15();
        TutorialMap.move(stage, -21.0, 2.0);
        base.addModels(stage);
        return new WorldObject(base);
    }

    private static ModelGroup stage01() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b01 \u30b9\u30b9\u3080", "\u30b3\u309b\u30fc\u30eb\u307e\u3066\u309b\u30b9\u30b9\u3082\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        base.addModels(TutorialMap.makeBlock(0.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage02() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b02 \u30de\u304b\u309b\u308b", "\u30de\u304b\u309b\u3064\u305f\u30df\u30c1\u3092\u30b9\u30b9\u3082\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 0.0}});
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage03() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b03 \u30ce\u30db\u309b\u308b", "\u30aa\u30ab\u3092\u30b3\u3048\u3088\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {1.25, 1.25, 1.25}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}});
        double[] height = new double[]{1.25, 1.25, 1.0, 1.0};
        base.addModels(TutorialMap.makeBlock(0.0, 1.0, 1.0, 1.0, height, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 1.0, 1.0, 1.0, height, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 1.0, 1.0, 1.0, height, ColorEnum.MAP_YELLOW.getRgba()));
        double[] height2 = new double[]{1.0, 1.0, 1.25, 1.25};
        base.addModels(TutorialMap.makeBlock(0.0, 3.0, 1.0, 1.0, height2, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 3.0, 1.0, 1.0, height2, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 3.0, 1.0, 1.0, height2, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(0.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage04() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b04 \u30a6\u30b3\u309b\u304b\u3059", "\u30e2\u30ce\u3092\u30aa\u30af\u307e\u3066\u309b\u30a6\u30b3\u309b\u304b\u305d\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        base.addModels(TutorialMap.makeBlock(0.0, 4.0, 1.0, ColorEnum.MAP_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 4.0, 1.0, ColorEnum.MAP_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.0, ColorEnum.MAP_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage05() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b05 \u30ce\u305b\u308b", "\u30e2\u30ce\u3092\u30ce\u305b\u3088\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{1.0, 1.0, 0.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.25, ColorEnum.MAP_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage06() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextB(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b06 \u30c4\u3080", "\u30e2\u30ce\u3092\u30c4\u3082\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        deco.addModels(TutorialMap.makeBlock(1.375, 1.375, 0.25, 0.25, 1.001, ColorEnum.MAP_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage07() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextB(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b07 \u30ef\u30bf\u308b", "\u30db\u30bd\u3044\u30df\u30c1\u3092\u30ef\u30bf\u308d\u3046"});
        base.addModels(TutorialMap.makeBlock(1.4375, 1.0, 0.125, 1.0, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.4375, 2.0, 0.125, 1.0, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.4375, 3.0, 0.125, 1.0, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.4375, 4.0, 0.125, 1.0, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage08() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextB(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b08 \u30ef\u30bf\u308b2", "\u30de\u304b\u309b\u3064\u305f\u30db\u30bd\u3044\u30df\u30c1\u3092\u30ef\u30bf\u308d\u3046"});
        base.addModels(TutorialMap.makeBlock(2.4375, 1.0, 0.125, 1.4375, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(0.4375, 2.4375, 2.125, 0.125, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(0.4375, 2.5625, 0.125, 1.4375, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(0.4375, 4.0, 0.125, 1.0, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage09() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextB(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b09 \u30b3\u3048\u308b", "\u30ab\u30d8\u309b\u3092\u30b3\u3048\u3088\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}});
        base.addModels(TutorialMap.makeBlock(0.0, 2.5, 1.0, 0.5, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 2.5, 1.0, 0.5, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 2.5, 1.0, 0.5, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(0.0, 2.0, 1.0, 0.5, 1.5, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 2.0, 1.0, 0.5, 1.5, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 2.0, 1.0, 0.5, 1.5, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(0.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage10() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextB(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b10 \u30b3\u3048\u308b2", "\u30bf\u30cb\u3092\u30b3\u3048\u3088\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}});
        base.addModels(TutorialMap.makeBlock(0.0, 2.5, 1.0, 0.5, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 2.5, 1.0, 0.5, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 2.5, 1.0, 0.5, 1.0, ColorEnum.MAP_YELLOW.getRgba()));
        base.addModels(TutorialMap.makeBlock(0.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 0.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage11() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b11 \u30ce\u30db\u309b\u308b", "\u30bf\u30ab\u3044\u30ab\u30d8\u309b\u3092\u30ce\u30db\u309b\u308d\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {3.0, 3.0, 3.0}, {3.0, 3.0, 3.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 4) {
                BoxShape box = TutorialMap.newBoxShape(2.0f, 2.0f, 20.0f, ColorEnum.MAP_ORANGE.getRgba());
                box.rotateP(Vector.ZERO, Vector.X_AXIS, 0.2617993877991494);
                box.moveP(new MutVector().set(((double)(i % 2) / 3.0 + 0.25 + (double)j / 1.5) * 72.0, ((double)i / 3.0 + 1.25) * 72.0, 139.5));
                base.addModels(box);
                ++j;
            }
            ++i;
        }
        base.addModels(TutorialMap.makeBlock(0.0, 4.0, 3.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 4.0, 3.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 3.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage12() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b12 \u30ef\u30bf\u308b3", "\u30a2\u30b7\u30cf\u309b\u3092\u30c4\u30bf\u3064\u3066\u30ef\u30bf\u308d\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}});
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                BoxShape box = TutorialMap.newBoxShape(4.0f, 72.0f, 4.0f, ColorEnum.MAP_ORANGE.getRgba());
                box.moveP(Vector.Y_AXIS, 36.0);
                TutorialMap.move(box, (double)i / 1.5 + 0.25 + (double)(j % 2) / 3.0, (double)j / 2.0 + 1.25);
                base.addModels(box);
                ++j;
            }
            ++i;
        }
        base.addModels(TutorialMap.makeBlock(0.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage13() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b13 \u30c8\u30c8\u309b\u3051\u308b", "\u30bf\u30a4\u30ab\u309b\u30f3\u307e\u3066\u309b\u30c8\u30c8\u309b\u3051\u3088\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{1.5, 1.5, 1.5}, {1.5, 0.0, 1.5}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}});
        base.addModels(TutorialMap.makeBlock(1.0, 3.0, 1.0, ColorEnum.MAP_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage14() {
        BoxShape box;
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b14 \u30ef\u30bf\u308b4", "\u30a6\u30f3\u30c6\u30a4\u3092\u30c4\u30bf\u3064\u3066\u30ef\u30bf\u308d\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}});
        int i = 0;
        while (i < 10) {
            box = TutorialMap.newBoxShape(72.0f, 2.0f, 2.0f, ColorEnum.MAP_ORANGE.getRgba());
            box.moveP(Vector.Y_AXIS, 126.0);
            TutorialMap.move(box, 1.5, (double)i / 3.0 + 0.5);
            base.addModels(box);
            ++i;
        }
        box = TutorialMap.newBoxShape(2.0f, 2.0f, 216.0f, ColorEnum.MAP_ORANGE.getRgba());
        box.moveP(Vector.Y_AXIS, 126.0);
        TutorialMap.move(box, 1.0, 2.0);
        base.addModels(box);
        box = TutorialMap.newBoxShape(2.0f, 2.0f, 216.0f, ColorEnum.MAP_ORANGE.getRgba());
        box.moveP(Vector.Y_AXIS, 126.0);
        TutorialMap.move(box, 2.0, 2.0);
        base.addModels(box);
        box = TutorialMap.newBoxShape(2.0f, 54.0f, 2.0f, ColorEnum.MAP_ORANGE.getRgba());
        box.moveP(Vector.Y_AXIS, 99.0);
        TutorialMap.move(box, 1.0, 0.5);
        base.addModels(box);
        box = TutorialMap.newBoxShape(2.0f, 54.0f, 2.0f, ColorEnum.MAP_ORANGE.getRgba());
        box.moveP(Vector.Y_AXIS, 99.0);
        TutorialMap.move(box, 2.0, 0.5);
        base.addModels(box);
        box = TutorialMap.newBoxShape(2.0f, 54.0f, 2.0f, ColorEnum.MAP_ORANGE.getRgba());
        box.moveP(Vector.Y_AXIS, 99.0);
        TutorialMap.move(box, 1.0, 3.5);
        base.addModels(box);
        box = TutorialMap.newBoxShape(2.0f, 54.0f, 2.0f, ColorEnum.MAP_ORANGE.getRgba());
        box.moveP(Vector.Y_AXIS, 99.0);
        TutorialMap.move(box, 2.0, 3.5);
        base.addModels(box);
        base.addModels(TutorialMap.makeBlock(0.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static ModelGroup stage15() {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        TutorialMap.makeTextA(deco, new String[]{"\u30b9\u30c6\u30fc\u30b7\u309b15 \u304f\u304f\u309b\u308b", "\u30e2\u3061\u30a2\u3051\u309b\u3066\u304f\u304f\u309b\u308a\u30cc\u3051\u3088\u3046"});
        TutorialMap.makeBlockMatrix(base, new double[][]{{0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}, {3.0, 1.0, 3.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}});
        BoxShape box = TutorialMap.newBoxShape(8.0f, 72.0f, 2.0f, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 108.0);
        TutorialMap.move(box, 1.0, 2.5);
        box.moveP(Vector.Z_AXIS, -2.25);
        base.addModels(box);
        box = TutorialMap.newBoxShape(8.0f, 72.0f, 2.0f, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 108.0);
        TutorialMap.move(box, 2.0, 2.5);
        box.moveP(Vector.Z_AXIS, -2.25);
        base.addModels(box);
        box = TutorialMap.newBoxShape(8.0f, 72.0f, 2.0f, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 108.0);
        TutorialMap.move(box, 1.0, 2.5);
        box.moveP(Vector.Z_AXIS, 2.25);
        base.addModels(box);
        box = TutorialMap.newBoxShape(8.0f, 72.0f, 2.0f, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 108.0);
        TutorialMap.move(box, 2.0, 2.5);
        box.moveP(Vector.Z_AXIS, 2.25);
        base.addModels(box);
        box = TutorialMap.makeBlock(1.0, 2.0, 1.0, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 144.0);
        base.addModels(box);
        base.addModels(TutorialMap.makeBlock(0.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(1.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        base.addModels(TutorialMap.makeBlock(2.0, 4.0, 1.0, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static void makeTextA(ModelGroup parent, String[] text) {
        int i = 0;
        while (i < text.length) {
            TextGroup t = new TextGroup(text[i], 3.0f);
            t.moveP(Vector.Y_AXIS, 84 - 3 * i);
            TutorialMap.move(t, 0.1, 0.0);
            parent.addModels(t);
            ++i;
        }
    }

    private static void makeTextB(ModelGroup parent, String[] text) {
        int i = 0;
        while (i < text.length) {
            TextGroup t = new TextGroup(text[i], 3.0f);
            t.moveP(Vector.Y_AXIS, 84 - 3 * i);
            TutorialMap.move(t, -0.9, -1.0);
            t.rotateP(new MutVector().set(72.0, 0.0, 144.0), Vector.Y_AXIS, Math.PI);
            parent.addModels(t);
            ++i;
        }
    }

    private static void move(Model obj, double x, double z) {
        obj.moveP(new MutVector().set(x * 72.0, 0.0, z * 72.0));
    }

    private static void makeBlockMatrix(ModelGroup parent, double[][] height) {
        int z = 0;
        while (z < height.length) {
            int x = 0;
            while (x < height[z].length) {
                if (height[height.length - 1 - z][x] > 0.0) {
                    parent.addModels(TutorialMap.makeBlock(x, z, height[height.length - 1 - z][x], ColorEnum.MAP_YELLOW.getRgba()));
                }
                ++x;
            }
            ++z;
        }
    }

    private static BoxShape makeBlock(double x, double z, double height, int color) {
        return TutorialMap.makeBlock(x, z, 1.0, 1.0, height, color);
    }

    private static BoxShape makeBlock(double x, double z, double width, double depth, double height, int color) {
        BoxShape rtn = new BoxShape((float)(width * 72.0), (float)(height *= 72.0), (float)(depth * 72.0), TextureEnum.WHITE.getAsInfo());
        rtn.setColor(color);
        rtn.moveP(new MutVector().set((x + width / 2.0) * 72.0, height / 2.0, (z + depth / 2.0) * 72.0));
        return rtn;
    }

    private static BoxShape makeBlock(double x, double z, double width, double depth, double[] height, int color) {
        float fx = (float)(width * 72.0 / 2.0);
        float[] fy = new float[4];
        float fz = (float)(depth * 72.0 / 2.0);
        int i = 0;
        while (i < 4) {
            fy[i] = (float)(height[i] * 72.0);
            ++i;
        }
        BoxShape rtn = new BoxShape(new float[]{-fx, fy[2], -fz, fx, fy[3], -fz, fx, fy[1], fz, -fx, fy[0], fz, -fx, 0.0f, -fz, fx, 0.0f, -fz, fx, 0.0f, fz, -fx, 0.0f, fz}, TextureEnum.WHITE.getAsInfo());
        rtn.setColor(color);
        rtn.moveP(new MutVector().set((x + width / 2.0) * 72.0, 0.0, (z + depth / 2.0) * 72.0));
        return rtn;
    }

    private static BoxShape newBoxShape(float w, float h, float d, int color) {
        BoxShape box = new BoxShape(w, h, d, TextureEnum.WHITE.getAsInfo());
        box.setColor(color);
        return box;
    }
}

