/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map.map;

import java.io.FileNotFoundException;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.system.utils.FileUtils;

public class RoboConMapA2
implements MapBuilder {
    public static final Vector FIRST_PLACE = new MutVector().set(48.0, 48.0, 48.0);

    @Override
    public Vector getFirstPlace() {
        return FIRST_PLACE;
    }

    @Override
    public PhysicsObject[] makeObjects() {
        PhysicsObject[] rtn = new PhysicsObject[1];
        try {
            Part block = MachineCompiler.compile(FileUtils.loadFile("res/object/box.bcm")).getMachinePart();
            block.getModel().moveP(new MutVector().set(20.0, 32.0, 320.0));
            rtn[0] = block;
        }
        catch (FileNotFoundException | CompileException e) {
            e.printStackTrace();
        }
        return rtn;
    }

    @Override
    public WorldObject make() {
        ModelGroup map = new ModelGroup();
        ModelGroup line = new ModelGroup(true, false);
        map.addModels(line);
        map.addModels(RoboConMapA2.makeBox(-144.0f, -192.0f, -4.0f, 288.0f, 384.0f, 4.0f, ColorEnum.GREEN.getRgba()));
        map.addModels(RoboConMapA2.makeBox(0.0f, 0.0f, 0.0f, 48.0f, 48.0f, 16.0f, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMapA2.makeBox(48.0f, 12.0f, 12.0f, 48.0f, 24.0f, 4.0f, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMapA2.makeBox(96.0f, 0.0f, 0.0f, 48.0f, 48.0f, 16.0f, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMapA2.makeBox(112.0f, 16.0f, 16.0f, 16.0f, 16.0f, 6.0f, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        map.addModels(RoboConMapA2.makeBox(0.0f, 144.0f, 0.0f, 144.0f, 48.0f, 16.0f, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMapA2.makeBox(new float[]{0.0f, 16.0f, 48.0f, 48.0f, 16.0f, 48.0f, 48.0f, 0.0f, 80.0f, 0.0f, 0.0f, 80.0f, 0.0f, 0.0f, 48.0f, 48.0f, 0.0f, 48.0f, 48.0f, 0.0f, 80.0f, 0.0f, 0.0f, 80.0f}, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMapA2.makeBox(new float[]{96.0f, 0.0f, 112.0f, 144.0f, 0.0f, 112.0f, 144.0f, 16.0f, 144.0f, 96.0f, 16.0f, 144.0f, 96.0f, 0.0f, 112.0f, 144.0f, 0.0f, 112.0f, 144.0f, 0.0f, 144.0f, 96.0f, 0.0f, 144.0f}, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMapA2.makeBox(48.0f, 48.0f, 0.0f, 2.0f, 64.0f, 2.0f, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMapA2.makeBox(94.0f, 80.0f, 0.0f, 2.0f, 64.0f, 2.0f, ColorEnum.MAP_YELLOW.getRgba()));
        line.addModels(RoboConMapA2.makeBox(-120.0f, 24.0f, -3.0f, 4.0f, 144.0f, 3.02f, ColorEnum.WHITE.getRgba()));
        line.addModels(RoboConMapA2.makeBox(-120.0f, 164.0f, -3.0f, 96.0f, 4.0f, 3.02f, ColorEnum.WHITE.getRgba()));
        line.addModels(RoboConMapA2.makeBox(-28.0f, 96.0f, -3.0f, 4.0f, 72.0f, 3.02f, ColorEnum.WHITE.getRgba()));
        line.addModels(RoboConMapA2.makeBox(-64.0f, 96.0f, -3.0f, 40.0f, 4.0f, 3.02f, ColorEnum.WHITE.getRgba()));
        line.addModels(RoboConMapA2.makeBox(-64.0f, 24.0f, -3.0f, 4.0f, 76.0f, 3.02f, ColorEnum.WHITE.getRgba()));
        line.addModels(RoboConMapA2.makeBox(-120.0f, 24.0f, -3.0f, 60.0f, 4.0f, 3.02f, ColorEnum.WHITE.getRgba()));
        int i = 1;
        while (i < 6) {
            line.addModels(RoboConMapA2.makeBox(-120.0f, -168 + i * 24 - 2, -3.0f, 96.0f, 4.0f, 3.02f, ColorEnum.WHITE.getRgba()));
            ++i;
        }
        i = 1;
        while (i < 4) {
            line.addModels(RoboConMapA2.makeBox(-120 + i * 24 - 2, -168.0f, -3.0f, 4.0f, 144.0f, 3.02f, ColorEnum.WHITE.getRgba()));
            ++i;
        }
        return new WorldObject(map);
    }

    private static BoxShape makeBox(float x, float z, float y, float width, float depth, float height, int color) {
        return RoboConMapA2.makeBox(new float[]{x, y + height, z, x + width, y + height, z, x + width, y + height, z + depth, x, y + height, z + depth, x, y, z, x + width, y, z, x + width, y, z + depth, x, y, z + depth}, color);
    }

    private static BoxShape makeBox(float[] vertex, int color) {
        int i = 0;
        while (i < 24) {
            int n = i++;
            vertex[n] = vertex[n] * 2.0f;
        }
        BoxShape rtn = new BoxShape(vertex, TextureEnum.WHITE.getAsInfo());
        rtn.setColor(color);
        return rtn;
    }
}

