/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map.map;

import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.model.TextGroup;

public class RoboConMap2022
implements MapBuilder {
    public static final Vector FIRST_PLACE = new MutVector().set(44.0, 0.0, -444.0);

    @Override
    public Vector getFirstPlace() {
        return FIRST_PLACE;
    }

    @Override
    public WorldObject make() {
        ModelGroup map = RoboConMap2022.makeMap(ColorEnum.MAP_BLUE.getRgba());
        ModelGroup map2 = RoboConMap2022.makeMap(ColorEnum.MAP_RED.getRgba());
        map2.moveL(Vector.X_AXIS, 568.0);
        map2.rotateL(Vector.ZERO, Vector.Y_AXIS, Math.PI);
        ModelGroup all = new ModelGroup();
        all.addModels(map, map2);
        all.addModels(RoboConMap2022.makeBox(-50.0f, -350.0f, -10.0f, 384.0f, 700.0f, 2.0f, ColorEnum.GREEN.getRgba()));
        return new WorldObject(all);
    }

    private static ModelGroup makeMap(int mainColor) {
        ModelGroup map = new ModelGroup();
        ModelGroup line = new ModelGroup(true, false);
        map.addModels(line);
        map.addModels(RoboConMap2022.makeBox(4.0f, 20.0f, 196.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(4.0f, 200.0f, 16.0f, 180.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(24.0f, 200.0f, 16.0f, 160.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(24.0f, 40.0f, 86.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(120.0f, 40.0f, 60.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(184.0f, 80.0f, 16.0f, 60.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(164.0f, 60.0f, 16.0f, 20.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(44.0f, 60.0f, 120.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(44.0f, 120.0f, 16.0f, 60.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(64.0f, 100.0f, 16.0f, 36.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(80.0f, 80.0f, 104.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(80.0f, 100.0f, 64.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(60.0f, 120.0f, 116.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(154.0f, 100.0f, 66.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(186.0f, 120.0f, 54.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(186.0f, 120.0f, 54.0f, 16.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(224.0f, 104.0f, 16.0f, 20.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(110.0f, 40.0f, 10.0f, 6.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(144.0f, 90.0f, 10.0f, 6.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(176.0f, 120.0f, 10.0f, 6.0f, mainColor));
        map.addModels(RoboConMap2022.makeBox(204.0f, 84.0f, 16.0f, 80.0f, ColorEnum.MAP_GREEN.getRgba()));
        map.addModels(RoboConMap2022.makeBox(220.0f, 20.0f, 60.0f, 16.0f, ColorEnum.MAP_GREEN.getRgba()));
        map.addModels(RoboConMap2022.makeBox(224.0f, 84.0f, 16.0f, 44.0f, ColorEnum.MAP_GREEN.getRgba()));
        map.addModels(RoboConMap2022.makeBox(224.0f, 40.0f, 26.0f, 16.0f, ColorEnum.MAP_GREEN.getRgba()));
        map.addModels(RoboConMap2022.makeBox(244.0f, 200.0f, 16.0f, 160.0f, ColorEnum.MAP_GREEN.getRgba()));
        map.addModels(RoboConMap2022.makeBox(264.0f, 200.0f, 16.0f, 180.0f, ColorEnum.MAP_GREEN.getRgba()));
        map.addModels(RoboConMap2022.makeRoof(204.0f, 84.0f, 76.0f, 80.0f, ColorEnum.BLACK.getTransparentRgba()));
        map.addModels(RoboConMap2022.makeRoof(244.0f, 200.0f, 36.0f, 116.0f, ColorEnum.BLACK.getTransparentRgba()));
        map.addModels(RoboConMap2022.makeBox(250.0f, 40.0f, 10.0f, 6.0f, ColorEnum.MAP_GREEN.getRgba()));
        map.addModels(RoboConMap2022.makeBox(4.0f, 240.0f, 36.0f, 36.0f, ColorEnum.MAP_YELLOW.getRgba()));
        map.addModels(RoboConMap2022.makeBox(228.0f, 272.0f, 68.0f, 68.0f, ColorEnum.MAP_ORANGE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(20.0f, 200.0f, 4.0f, 176.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(20.0f, 24.0f, 164.0f, 4.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(180.0f, 60.0f, 4.0f, 36.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(60.0f, 64.0f, 124.0f, 4.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(60.0f, 100.0f, 4.0f, 36.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(60.0f, 104.0f, 164.0f, 4.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(220.0f, 100.0f, 4.0f, 76.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(220.0f, 24.0f, 44.0f, 4.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(260.0f, 200.0f, 4.0f, 176.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(4.0f, 204.0f, 36.0f, 4.0f, ColorEnum.WHITE.getRgba()));
        map.addModels(RoboConMap2022.makeBox(244.0f, 204.0f, 36.0f, 4.0f, ColorEnum.WHITE.getRgba()));
        ModelGroup wallB = new ModelGroup(true, true);
        ModelGroup wallT = new ModelGroup(false, true);
        RoboConMap2022.makeWall(0.0f, 4.0f, 284.0f, 4.0f, wallB, wallT);
        RoboConMap2022.makeWall(0.0f, 240.0f, 4.0f, 236.0f, wallB, wallT);
        RoboConMap2022.makeWall(0.0f, 244.0f, 44.0f, 4.0f, wallB, wallT);
        RoboConMap2022.makeWall(40.0f, 44.0f, 124.0f, 4.0f, wallB, wallT);
        RoboConMap2022.makeWall(40.0f, 240.0f, 4.0f, 196.0f, wallB, wallT);
        RoboConMap2022.makeWall(200.0f, 80.0f, 4.0f, 76.0f, wallB, wallT);
        RoboConMap2022.makeWall(80.0f, 84.0f, 124.0f, 4.0f, wallB, wallT);
        RoboConMap2022.makeWall(44.0f, 124.0f, 196.0f, 4.0f, wallB, wallT);
        RoboConMap2022.makeWall(240.0f, 200.0f, 4.0f, 160.0f, wallB, wallT);
        RoboConMap2022.makeWall(280.0f, 200.0f, 4.0f, 196.0f, wallB, wallT);
        RoboConMap2022.makeWall(224.0f, 204.0f, 20.0f, 4.0f, wallB, wallT);
        RoboConMap2022.makeWall(280.0f, 204.0f, 20.0f, 4.0f, wallB, wallT);
        RoboConMap2022.makeWall(224.0f, 272.0f, 4.0f, 68.0f, wallB, wallT);
        RoboConMap2022.makeWall(296.0f, 272.0f, 4.0f, 68.0f, wallB, wallT);
        RoboConMap2022.makeWall(224.0f, 276.0f, 76.0f, 4.0f, wallB, wallT);
        map.addModels(wallB, wallT);
        ModelGroup text = RoboConMap2022.makeText("\u30b7\u30e6\u30c8\u309b\u30a6\u30ad", "\u30b3\u30b3\u30c6\u309b", "Z\u30ad\u30fc");
        text.moveP(new MutVector().set(0.0, 0.0, -490.0));
        map.addModels(text);
        ModelGroup text2 = RoboConMap2022.makeText("\u30b7\u309b\u30c8\u309b\u30a6\u30ad", "\u30b3\u30b3\u30c6\u309b", "Z\u30ad\u30fc");
        text2.moveP(new MutVector().set(480.0, 0.0, -554.0));
        map.addModels(text2);
        return map;
    }

    private static BoxShape makeRoof(float x, float z, float width, float depth, int color) {
        BoxShape roof = RoboConMap2022.makeBox(x, -z, 24.0f, width, depth, 2.0f, color);
        roof.setOpaque(false);
        return roof;
    }

    private static ModelGroup makeText(String ... text) {
        ModelGroup lines = new ModelGroup(true, false);
        int i = 0;
        while (i < text.length) {
            TextGroup t = new TextGroup(text[i], 3.0f);
            t.moveP(Vector.Y_AXIS, -3 * i);
            lines.addModels(t);
            ++i;
        }
        return lines;
    }

    private static void makeWall(float x, float z, float width, float depth, ModelGroup wallB, ModelGroup wallT) {
        BoxShape b = RoboConMap2022.makeBox(x, -z, -10.0f, width, depth, 12.0f, ColorEnum.BLACK.getRgba());
        BoxShape t = RoboConMap2022.makeBox(x, -z, 2.0f, width, depth, 72.0f, ColorEnum.BLACK.getTransparentRgba());
        t.setOpaque(false);
        wallB.addModels(b);
        wallT.addModels(t);
    }

    private static BoxShape makeBox(float x, float z, float width, float depth, int color) {
        return RoboConMap2022.makeBox(x, -z, -10.0f, width, depth, 10.0f, color);
    }

    private static BoxShape makeBox(float x, float z, float y, float width, float depth, float height, int color) {
        return RoboConMap2022.makeBox(new float[]{x, y + height, z, x + width, y + height, z, x + width, y + height, z + depth, x, y + height, z + depth, x, y, z, x + width, y, z, x + width, y, z + depth, x, y, z + depth}, color);
    }

    private static BoxShape makeBox(float[] vertex, int color) {
        int i = 0;
        while (i < 24) {
            int n = i++;
            vertex[n] = vertex[n] * 2.0f;
        }
        BoxShape box = new BoxShape(vertex, TextureEnum.WHITE.getAsInfo());
        box.setColor(color);
        return box;
    }
}

