/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map.map;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.map.MapProgram;
import net.comp_lot.craftalos.map.ObjMap;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.model.utils.Bound;

public class RaceMap
extends ObjMap {
    public RaceMap() {
        super("res/map/raceMap.obj");
    }

    @Override
    public MapProgram getProgram() {
        return new Program();
    }

    private class Program
    implements MapProgram {
        private long time = 1L;
        private Set<Machine> startMachine = new HashSet<Machine>();
        private Set<Machine> joinMachine = new HashSet<Machine>();
        private final Bound startArea = this.makeBound(-120.0, 150.0, -50.0, 100.0, -230.0, 130.0);
        private final Bound goalArea = this.makeBound(-120.0, 150.0, -50.0, 50.0, 130.0, 140.0);
        private final Bound goalForwardArea = this.makeBound(-120.0, 150.0, -50.0, 50.0, 140.0, 240.0);

        private Program() {
        }

        @Override
        public void accept(List<Machine> list, Consumer<String> printer) {
            list.parallelStream().filter(m -> m.getAction()).forEach(m -> {
                if (this.startArea.contain(m.getModel().getBound())) {
                    this.time = -180L;
                    this.joinMachine.clear();
                    this.startMachine.clear();
                    this.joinMachine.addAll(list);
                } else {
                    m.print("\u3053\u3053\u3066\u309b\u306f\u30e0\u30b3\u30a6\u3066\u309b\u3059");
                }
            });
            if (this.time < 0L && this.time % 60L == 0L) {
                printer.accept("#-" + -this.time / 60L + "-");
            } else if (this.time == 0L) {
                printer.accept("#-Start-");
            }
            ++this.time;
            if (this.time > 0L) {
                list.parallelStream().filter(m -> this.joinMachine.contains(m) && !this.startArea.crossing(m.getModel().getBound())).forEach(m -> {
                    this.joinMachine.remove(m);
                    this.startMachine.add((Machine)m);
                });
                list.parallelStream().filter(m -> this.startMachine.contains(m) && this.goalArea.crossing(m.getModel().getBound()) && !this.goalForwardArea.crossing(m.getModel().getBound())).forEach(m -> {
                    printer.accept(String.format("Goal!! %.1f", (double)this.time / 60.0));
                    m.print(String.format("#Goal!! %.1f", (double)this.time / 60.0));
                    this.startMachine.remove(m);
                });
            }
        }

        private Bound makeBound(double x1, double x2, double y1, double y2, double z1, double z2) {
            Bound b = new Bound();
            b.set(new MutVector().set(x1, y1, z1));
            b.set(new MutVector().set(x2, y2, z2));
            return b;
        }
    }
}

