/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map.map;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.model.TextGroup;
import net.comp_lot.glui.system.utils.FileUtils;

public class MiniRoboConMap
implements MapBuilder {
    private static final int BLOCK_SIZE = 72;
    private static final Vector FIRST_PLACE = new MutVector().set(72.0, 76.0, 0.0);
    private static final Vector[] RESTART_PLACES = new Vector[]{new MutVector().set(0.0, 76.0, 72.0), new MutVector().set(288.0, 76.0, 72.0), new MutVector().set(576.0, 76.0, 72.0), new MutVector().set(864.0, 76.0, 72.0), new MutVector().set(1152.0, 76.0, 72.0)};
    private static final Vector[] RESTART_ROTATES = new Vector[]{new MutVector().set(Vector.ZERO), new MutVector().set(Vector.ZERO), new MutVector().set(Vector.ZERO), new MutVector().set(Vector.ZERO), new MutVector().set(Vector.ZERO)};

    @Override
    public Vector[] getRestartPlaces() {
        return RESTART_PLACES;
    }

    @Override
    public Vector[] getRestartRotates() {
        return RESTART_ROTATES;
    }

    @Override
    public PhysicsObject[] makeObjects() {
        ArrayList<Part> list = new ArrayList<Part>();
        try {
            int i = 0;
            while (i < 5) {
                Part block = MachineCompiler.compile(FileUtils.loadFile("res/object/_HamBurger.bcm")).getMachinePart();
                MiniRoboConMap.move(block.getModel(), i * 4, 8.0);
                block.getModel().moveP(Vector.Y_AXIS, 100.8);
                list.add(block);
                ++i;
            }
        }
        catch (FileNotFoundException | CompileException e) {
            e.printStackTrace();
        }
        return list.toArray(new PhysicsObject[list.size()]);
    }

    @Override
    public Vector getFirstPlace() {
        return FIRST_PLACE;
    }

    @Override
    public WorldObject make() {
        ModelGroup base = new ModelGroup();
        ModelGroup street = new ModelGroup();
        BoxShape box = MiniRoboConMap.makeBlock(0.0, 0.0, 20.0, 3.0, 1.0, ColorEnum.MAP_YELLOW.getRgba());
        MiniRoboConMap.move(box, 8.5, 0.0);
        street.addModels(box);
        base.addModels(street);
        ModelGroup stage = MiniRoboConMap.stage03(1);
        MiniRoboConMap.move(stage, 0.0, 2.0);
        base.addModels(stage);
        stage = MiniRoboConMap.stage03(2);
        MiniRoboConMap.move(stage, 4.0, 2.0);
        base.addModels(stage);
        stage = MiniRoboConMap.stage03(3);
        MiniRoboConMap.move(stage, 8.0, 2.0);
        base.addModels(stage);
        stage = MiniRoboConMap.stage03(4);
        MiniRoboConMap.move(stage, 12.0, 2.0);
        base.addModels(stage);
        stage = MiniRoboConMap.stage03(5);
        MiniRoboConMap.move(stage, 16.0, 2.0);
        base.addModels(stage);
        return new WorldObject(base);
    }

    private static ModelGroup stage03(int i) {
        ModelGroup base = new ModelGroup();
        ModelGroup deco = new ModelGroup(true, false);
        base.addModels(deco);
        MiniRoboConMap.makeTextA(deco, new String[]{"\u30ec\u30fc\u30f3" + i, "\u30e2\u30ce\u3092\u30ab\u30a4\u30b7\u30e6\u30a6\u3057\u3088\u3046"});
        MiniRoboConMap.makeBlockMatrix(base, new double[][]{{1.35, 1.0, 1.35}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.35, 1.0, 1.35}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 0.0}});
        double[] height = new double[]{1.35, 1.35, 1.175, 1.175};
        base.addModels(MiniRoboConMap.makeBlock(0.0, 2.0, 1.0, 1.0, height, ColorEnum.MAP_GREEN.getRgba()));
        double[] height2 = new double[]{1.175, 1.175, 1.0, 1.0};
        base.addModels(MiniRoboConMap.makeBlock(0.0, 1.0, 1.0, 1.0, height2, ColorEnum.MAP_GREEN.getRgba()));
        BoxShape box = MiniRoboConMap.makeBlock(1.0, 3.0, 0.05, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 93.60000000000001);
        base.addModels(box);
        box = MiniRoboConMap.makeBlock(2.0, 4.0, 0.05, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 93.60000000000001);
        base.addModels(box);
        box = MiniRoboConMap.makeBlock(2.0, 5.0, 0.05, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 93.60000000000001);
        base.addModels(box);
        box = MiniRoboConMap.makeBlock(1.0, 6.0, 0.05, ColorEnum.MAP_YELLOW.getRgba());
        box.moveP(Vector.Y_AXIS, 93.60000000000001);
        base.addModels(box);
        base.addModels(MiniRoboConMap.makeBlock(2.0, 0.0, 1.2, ColorEnum.MAP_LIGHT_BLUE.getRgba()));
        return base;
    }

    private static void makeTextA(ModelGroup parent, String[] text) {
        int i = 0;
        while (i < text.length) {
            TextGroup t = new TextGroup(text[i], 3.0f);
            t.moveP(Vector.Y_AXIS, 84 - 3 * i);
            MiniRoboConMap.move(t, -0.4, -0.5);
            parent.addModels(t);
            ++i;
        }
    }

    private static void move(Model obj, double x, double z) {
        obj.moveP(new MutVector().set(x * 72.0, 0.0, z * 72.0));
    }

    private static void makeBlockMatrix(ModelGroup parent, double[][] height) {
        int z = 0;
        while (z < height.length) {
            int x = 0;
            while (x < height[z].length) {
                if (height[height.length - 1 - z][x] > 0.0) {
                    parent.addModels(MiniRoboConMap.makeBlock(x, z, height[height.length - 1 - z][x], ColorEnum.MAP_GREEN.getRgba()));
                }
                ++x;
            }
            ++z;
        }
    }

    private static BoxShape makeBlock(double x, double z, double height, int color) {
        return MiniRoboConMap.makeBlock(x, z, 1.0, 1.0, height, color);
    }

    private static BoxShape makeBlock(double x, double z, double width, double depth, double height, int color) {
        BoxShape rtn = new BoxShape((float)(width * 72.0), (float)(height *= 72.0), (float)(depth * 72.0), TextureEnum.WHITE.getAsInfo());
        rtn.setColor(color);
        rtn.moveP(new MutVector().set(x * 72.0, height / 2.0, z * 72.0));
        return rtn;
    }

    private static BoxShape makeBlock(double x, double z, double width, double depth, double[] height, int color) {
        float fx = (float)(width * 72.0 / 2.0);
        float[] fy = new float[4];
        float fz = (float)(depth * 72.0 / 2.0);
        int i = 0;
        while (i < 4) {
            fy[i] = (float)(height[i] * 72.0);
            ++i;
        }
        BoxShape rtn = new BoxShape(new float[]{-fx, fy[2], -fz, fx, fy[3], -fz, fx, fy[1], fz, -fx, fy[0], fz, -fx, 0.0f, -fz, fx, 0.0f, -fz, fx, 0.0f, fz, -fx, 0.0f, fz}, TextureEnum.WHITE.getAsInfo());
        rtn.setColor(color);
        rtn.moveP(new MutVector().set(x * 72.0, 0.0, z * 72.0));
        return rtn;
    }
}

