/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map.map;

import java.io.FileNotFoundException;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.system.utils.FileUtils;

public class AdventureMap1
implements MapBuilder {
    private static final float BLOCK_SIZE = 60.0f;
    private static final float BLOCK_HEIGHT = 30.0f;
    private static final Vector FIRST_PLACE = new MutVector().set(0.0, -24.0, -150.0);
    private static final Vector FIRST_ROTATE = new MutVector().set(Vector.Y_AXIS).resize(1.5707963267948966);

    @Override
    public Vector getFirstPlace() {
        return FIRST_PLACE;
    }

    @Override
    public Vector getFirstRotate() {
        return FIRST_ROTATE;
    }

    @Override
    public PhysicsObject[] makeObjects() {
        PhysicsObject[] rtn = new PhysicsObject[1];
        try {
            Part block = MachineCompiler.compile(FileUtils.loadFile("res/object/box.bcm")).getMachinePart();
            block.getModel().moveP(new MutVector().set(-80.0, 0.0, 100.0));
            rtn[0] = block;
        }
        catch (FileNotFoundException | CompileException e) {
            e.printStackTrace();
        }
        return rtn;
    }

    @Override
    public WorldObject make() {
        ModelGroup map = new ModelGroup();
        float[] vertex = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f, 16.0f, 16.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 16.0f, 16.0f, -1.0f, 16.0f, 16.0f, -1.0f, 0.0f};
        BoxShape floor = AdventureMap1.make(vertex, ColorEnum.MAP_GREEN.getRgba());
        map.addModels(floor);
        vertex = new float[]{0.0f, 4.0f, 0.0f, 0.0f, 5.0f, 1.0f, 2.0f, 5.0f, 1.0f, 2.0f, 4.0f, 0.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{0.0f, 5.0f, 1.0f, 0.0f, 5.0f, 3.0f, 2.0f, 5.0f, 3.0f, 2.0f, 5.0f, 1.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{0.0f, 5.0f, 3.0f, 0.0f, 1.0f, 7.0f, 2.0f, 1.0f, 7.0f, 2.0f, 5.0f, 3.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{0.0f, 1.0f, 7.0f, 0.0f, 1.0f, 8.0f, 2.0f, 1.0f, 8.0f, 2.0f, 1.0f, 7.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{2.0f, 1.0f, 7.0f, 2.0f, 1.0f, 8.0f, 3.0f, 0.0f, 8.0f, 3.0f, 0.0f, 7.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{2.0f, 5.0f, 2.0f, 2.0f, 5.0f, 3.0f, 4.0f, 5.0f, 3.0f, 4.0f, 5.0f, 2.0f, 2.0f, 4.0f, 2.0f, 2.0f, 4.0f, 3.0f, 4.0f, 4.0f, 3.0f, 4.0f, 4.0f, 2.0f};
        map.addModels(AdventureMap1.make(vertex, ColorEnum.WHITE.getRgba()));
        vertex = new float[]{3.0f, 0.0f, 1.0f, 3.0f, 0.0f, 2.0f, 7.0f, 4.0f, 2.0f, 7.0f, 4.0f, 1.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{7.0f, 4.0f, 1.0f, 7.0f, 4.0f, 2.0f, 8.0f, 4.0f, 2.0f, 8.0f, 4.0f, 1.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{4.0f, 5.0f, 2.0f, 4.0f, 5.0f, 3.0f, 5.0f, 4.0f, 3.0f, 5.0f, 4.0f, 2.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{5.0f, 4.0f, 2.0f, 5.0f, 4.0f, 3.0f, 8.0f, 4.0f, 3.0f, 8.0f, 4.0f, 2.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        vertex = new float[]{7.0f, 4.0f, 3.0f, 7.0f, 0.0f, 9.0f, 8.0f, 0.0f, 9.0f, 8.0f, 4.0f, 3.0f};
        map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
        int i = 0;
        while (i < 30) {
            float h = 4.0f - (float)i * 0.13333334f;
            float z = 3.0f + (float)i * 0.2f;
            float z2 = 3.0f + (float)(i + 1) * 0.2f;
            vertex = new float[]{5.0f, h, z, 5.0f, h, z2, 7.0f, h, z2, 7.0f, h, z};
            map.addModels(AdventureMap1.make2(vertex, ColorEnum.MAP_YELLOW.getRgba()));
            ++i;
        }
        map.moveP(new MutVector().set(-240.0, -30.0, 420.0));
        return new WorldObject(map);
    }

    private static BoxShape make2(float[] vertex, int color) {
        float[] vertex2 = new float[24];
        int i = 0;
        while (i < 24) {
            vertex2[i] = i >= 12 && i % 3 == 1 ? -0.1f : vertex[i % 12];
            ++i;
        }
        return AdventureMap1.make(vertex2, color);
    }

    private static BoxShape make(float[] vertex, int color) {
        int i = 0;
        while (i < 24) {
            vertex[i] = vertex[i] * (i % 3 == 1 ? 30.0f : (i % 3 == 2 ? -60.0f : 60.0f));
            ++i;
        }
        BoxShape box = new BoxShape(vertex, TextureEnum.WHITE.getAsInfo());
        box.setColor(color);
        return box;
    }
}

