/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.comp_lot.craftalos.bot.AirBattleBot;
import net.comp_lot.craftalos.bot.AirBot;
import net.comp_lot.craftalos.bot.BattleRaceBot;
import net.comp_lot.craftalos.bot.Bot;
import net.comp_lot.craftalos.bot.JunkTankBot;
import net.comp_lot.craftalos.bot.JunkTurretBot;
import net.comp_lot.craftalos.bot.LongTurretBot;
import net.comp_lot.craftalos.bot.RaceBot;
import net.comp_lot.craftalos.bot.TankBot;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.map.MapProgram;
import net.comp_lot.craftalos.phisics.FixedPhysicsObject;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.craftalos.program.ProgramNode;
import net.comp_lot.craftalos.program.compiler.CompileException;
import net.comp_lot.craftalos.program.compiler.Includer;
import net.comp_lot.craftalos.program.compiler.MachineCompiler;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.program.compiler.ProgramCompiler;
import net.comp_lot.craftalos.program.node.FunDecNode;
import net.comp_lot.craftalos.program.node.NumNode;
import net.comp_lot.craftalos.program.node.StdFunDecNode;
import net.comp_lot.craftalos.program.node.StringNode;
import net.comp_lot.craftalos.program.node.TopNode;
import net.comp_lot.craftalos.program.node.VarDecNode;
import net.comp_lot.craftalos.system.World;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.system.utils.FileUtils;
import net.comp_lot.glui.system.utils.ObjParser;
import net.comp_lot.ui.core.Component;

public class ProgramableMap
implements MapBuilder,
MapProgram {
    private final World world;
    private final WorldObject map;
    private final TopNode program = new TopNode();
    private final MutVector startPlace = new MutVector();
    private final MutVector startRotate = new MutVector();
    private boolean restartable = true;
    private final List<Integer> playerMachineIds = new ArrayList<Integer>();
    private final Map<Integer, Machine> playerMachines = new HashMap<Integer, Machine>();
    private final Map<Integer, Machine> objects = new HashMap<Integer, Machine>();
    private final Map<Integer, Integer> teams = new HashMap<Integer, Integer>();
    private final Map<Integer, Bot> bots = new HashMap<Integer, Bot>();
    private Consumer<String> printer;
    private StringBuilder sb = new StringBuilder();

    public ProgramableMap(MapBuilder map, String programPath, World world) {
        this.world = world;
        this.map = map.make();
        this.map.getModel().callConfirmCoordinate();
        this.map.getModel().setBound();
        this.initProgram();
        try {
            String source = new Includer().include(FileUtils.loadFile(programPath));
            try {
                ProgramCompiler.compile(this.program, source);
            }
            catch (CompileException e) {
                System.err.println(e.getDetailMessage(source));
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void init() {
        try {
            this.program.runInit();
            this.program.getFunction("init(0)", -1).execute();
        }
        catch (MachineProgram.ProgramException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    private void initProgram() {
        VarDecNode pi = new VarDecNode(this.program, -1, "PI");
        pi.setInit(new NumNode(pi, -1, String.valueOf(Math.PI)));
        this.program.addChildToTop(pi);
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_start_place", context -> {
            this.startPlace.set(context.getVariable("x", -1).getValue(), context.getVariable("y", -1).getValue(), context.getVariable("z", -1).getValue());
            this.startRotate.set(Vector.Y_AXIS).resize(context.getVariable("r", -1).getValue());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "x", "y", "z", "r"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "print_int", context -> {
            this.sb.append((int)context.getVariable("num", -1).getValue());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "num"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "print_float", context -> {
            this.sb.append(String.format("%.2f", context.getVariable("num", -1).getValue()));
            return ProgramNode.Result.getNormalResult(0.0);
        }, "num"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "print_str", context -> {
            this.sb.append(StringNode.get((int)context.getVariable("str", -1).getValue()).replaceAll("\\\\\\\\n", "\n"));
            return ProgramNode.Result.getNormalResult(0.0);
        }, "str"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "println", context -> {
            if (context.getVariable("id", -1).getValue() < 0.0) {
                this.printer.accept(this.sb.toString());
            } else {
                this.playerMachines.get((int)context.getVariable("id", -1).getValue()).print(this.sb.toString());
            }
            this.sb.delete(0, this.sb.length());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "print_place", context -> {
            this.sb.append(this.playerMachines.get((int)context.getVariable("id", -1).getValue()).getMachinePart().getCenter());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_restartable", context -> {
            this.restartable = context.getVariable("able", -1).getValue() != 0.0;
            this.playerMachines.values().parallelStream().forEach(m -> m.setCanRestart(this.restartable));
            return ProgramNode.Result.getNormalResult(0.0);
        }, "able"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "finish", context -> {
            this.printer.accept(String.format("!close(%s)", this.sb.toString()));
            return ProgramNode.Result.getNormalResult(0.0);
        }, new String[0]));
        this.program.addChildToTop(new StdFunDecNode(this.program, "finish", context -> {
            this.printer.accept(String.format("!close(%s)", StringNode.get((int)context.getVariable("state", -1).getValue())));
            return ProgramNode.Result.getNormalResult(0.0);
        }, "state"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "make", context -> {
            try {
                Machine o;
                String name = StringNode.get((int)context.getVariable("name", -1).getValue());
                if (name.endsWith(".bcm")) {
                    o = MachineCompiler.compile(FileUtils.loadFile(name));
                    this.world.addObject(o.getMachinePart());
                } else {
                    o = MachineCompiler.compile(FileUtils.loadFile(name + ".bcm"));
                    MachineProgram p = ProgramCompiler.compile(new Includer().include(FileUtils.loadFile(name + ".bcp")));
                    p.setPrinter(s -> System.err.println((String)s));
                    o.setProgram(p);
                    this.world.addMachine(o);
                }
                this.objects.put(o.getModel().id, o);
                return ProgramNode.Result.getNormalResult(o.getModel().id);
            }
            catch (FileNotFoundException | CompileException e) {
                throw new MachineProgram.ProgramException(e.getLocalizedMessage(), -1);
            }
        }, "name"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "destroy", context -> {
            int id = (int)context.getVariable("id", -1).getValue();
            Machine o = this.objects.remove(id);
            this.world.removeObject(o.getMachinePart());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_avatar", context -> {
            int id = (int)context.getVariable("id", -1).getValue();
            Machine o = this.objects.get(id);
            try {
                String name = StringNode.get((int)context.getVariable("name", -1).getValue());
                ModelGroup doll = new ObjParser(name, TextureEnum.WHITE.getAsInfo()).getModel();
                doll.moveP(new MutVector().set(context.getVariable("x", -1).getValue(), context.getVariable("y", -1).getValue(), context.getVariable("z", -1).getValue()));
                doll.setHasCollider(false);
                doll.setDecorative(true);
                o.getRootPart().getModel().setVisible(false);
                ((ModelGroup)o.getModel()).addModels(doll);
                return ProgramNode.Result.getNormalResult(o.getModel().id);
            }
            catch (FileNotFoundException e) {
                throw new MachineProgram.ProgramException(e.getLocalizedMessage(), -1);
            }
        }, "id", "name", "x", "y", "z"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "enable_physics", context -> {
            Machine o = this.objects.get((int)context.getVariable("id", -1).getValue());
            o.setFixed(false);
            this.world.enablePhysics(o.getMachinePart());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "disable_physics", context -> {
            Machine o = this.objects.get((int)context.getVariable("id", -1).getValue());
            o.setFixed(true);
            this.world.disablePhysics(o.getMachinePart());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "fix_physics", context -> {
            Machine o = this.objects.get((int)context.getVariable("id", -1).getValue());
            o.clearParts();
            this.world.disablePhysics(o.getMachinePart());
            this.world.enablePhysics(new FixedPhysicsObject(o.getMachinePart()));
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "move", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            MutVector p = new MutVector().set(context.getVariable("x", -1).getValue(), context.getVariable("y", -1).getValue(), context.getVariable("z", -1).getValue());
            MutVector r = new MutVector().set(Vector.Y_AXIS).resize(context.getVariable("r", -1).getValue());
            o.getModel().moveToP(p);
            o.getModel().rotateToP(p, r, ((Vector)r).getSize());
            o.getMachinePart().stopMotion();
            this.world.initCoordinateAndBound();
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id", "x", "y", "z", "r"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_velocity", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            MutVector v = new MutVector().set(context.getVariable("x", -1).getValue(), context.getVariable("y", -1).getValue(), context.getVariable("z", -1).getValue());
            o.getMachinePart().stopMotion();
            o.getMachinePart().setMoveBuf(v);
            this.world.initCoordinateAndBound();
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id", "x", "y", "z"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_angle", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            MutVector top = new MutVector();
            o.getModel().LocalToGlobal(top, Vector.Y_AXIS);
            return ProgramNode.Result.getNormalResult(Vector.Dot(top, Vector.Y_AXIS));
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_pos_x", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            return ProgramNode.Result.getNormalResult(o.getModel().getCoordinateSystem().getCenter().getX());
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_pos_y", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            return ProgramNode.Result.getNormalResult(o.getModel().getCoordinateSystem().getCenter().getY());
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_pos_z", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            return ProgramNode.Result.getNormalResult(o.getModel().getCoordinateSystem().getCenter().getZ());
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_distance", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            MutVector v = new MutVector().set(context.getVariable("x", -1).getValue(), context.getVariable("y", -1).getValue(), context.getVariable("z", -1).getValue());
            return ProgramNode.Result.getNormalResult(Math.sqrt(o.getModel().getCoordinateSystem().getCenter().getDistS(v)));
        }, "id", "x", "y", "z"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_bot", context -> {
            int id = (int)context.getVariable("id", -1).getValue();
            Object bot = StringNode.get((int)context.getVariable("bot", -1).getValue());
            if (!((String)bot).matches(".*\\(.*\\)")) {
                bot = (String)bot + "()";
            }
            this.setBot(id, (String)bot);
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id", "bot"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_bot_parameter", context -> {
            int id = (int)context.getVariable("id", -1).getValue();
            String name = StringNode.get((int)context.getVariable("name", -1).getValue());
            this.bots.get(id).setParameter(name, context.getVariable("value", -1).getValue());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id", "name", "value"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "make_area", context -> {
            Machine o = new Machine();
            BoxShape shape = new BoxShape((float)context.getVariable("w", -1).getValue(), (float)context.getVariable("h", -1).getValue(), (float)context.getVariable("d", -1).getValue(), TextureEnum.WHITE.getAsInfo());
            MutVector p2 = new MutVector().set(context.getVariable("w", -1).getValue(), context.getVariable("h", -1).getValue(), context.getVariable("d", -1).getValue()).scale(0.5);
            MutVector p1 = new MutVector().set(context.getVariable("x", -1).getValue(), context.getVariable("y", -1).getValue(), context.getVariable("z", -1).getValue()).add(p2);
            shape.moveP(p1);
            shape.setColor(Component.parseColor(StringNode.get((int)context.getVariable("color", -1).getValue())));
            shape.setOpaque(false);
            ((ModelGroup)o.getModel()).addModels(shape);
            o.getModel().callConfirmCoordinate();
            this.world.addObject(o.getMachinePart());
            this.world.disablePhysics(o.getMachinePart());
            this.objects.put(o.getModel().id, o);
            return ProgramNode.Result.getNormalResult(o.getModel().id);
        }, "x", "y", "z", "w", "h", "d", "color"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "in_area", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            if (!o.getModel().getBound().exist()) {
                return ProgramNode.Result.getNormalResult(0.0);
            }
            Bound b = ProgramableMap.getBound(context);
            return ProgramNode.Result.getNormalResult(b.contain(o.getModel().getBound()) ? 1 : 0);
        }, "id", "x", "y", "z", "w", "h", "d"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "cross_area", context -> {
            Machine o = this.getObjectById((int)context.getVariable("id", -1).getValue());
            if (!o.getModel().getBound().exist()) {
                return ProgramNode.Result.getNormalResult(0.0);
            }
            Bound b = ProgramableMap.getBound(context);
            return ProgramNode.Result.getNormalResult(b.crossing(o.getModel().getBound()) ? 1 : 0);
        }, "id", "x", "y", "z", "w", "h", "d"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_player_num", context -> ProgramNode.Result.getNormalResult(this.playerMachineIds.size()), new String[0]));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_player_id", context -> ProgramNode.Result.getNormalResult(this.playerMachineIds.get((int)context.getVariable("num", -1).getValue()).intValue()), "num"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_endurance", context -> ProgramNode.Result.getNormalResult(this.getObjectById((int)context.getVariable("id", -1).getValue()).getRemainEndurance()), "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_endurance", context -> {
            this.getObjectById((int)context.getVariable("id", -1).getValue()).setEndurance(context.getVariable("endurance", -1).getValue());
            this.world.initCoordinateAndBound();
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id", "endurance"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "reset_endurance", context -> {
            this.getObjectById((int)context.getVariable("id", -1).getValue()).resetEndurance();
            this.world.initCoordinateAndBound();
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "reset_pose", context -> {
            this.getObjectById((int)context.getVariable("id", -1).getValue()).resetPose();
            this.world.initCoordinateAndBound();
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_team", context -> {
            this.teams.put((int)context.getVariable("id", -1).getValue(), (int)context.getVariable("team", -1).getValue());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id", "team"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "get_team", context -> ProgramNode.Result.getNormalResult(this.teams.get((int)context.getVariable("id", -1).getValue()).intValue()), "id"));
        this.program.addChildToTop(new StdFunDecNode(this.program, "set_color", context -> {
            this.getObjectById((int)context.getVariable("id", -1).getValue()).setTex(ColorEnum.values()[(int)context.getVariable("color", -1).getValue()].getRgba());
            return ProgramNode.Result.getNormalResult(0.0);
        }, "id", "color"));
    }

    private void setBot(int id, String value) throws MachineProgram.ProgramException {
        String name = value.replaceAll("(.*)\\(.*\\)", "$1");
        String option = value.replaceAll(".*\\((.*)\\)", "$1");
        String[] options = option.isEmpty() ? new String[]{} : option.split(",");
        switch (name) {
            case "JunkTurretBot": {
                this.bots.put(id, new JunkTurretBot(this.objects.get(id).getModel(), this.map.getModel()));
                break;
            }
            case "JunkTankBot": {
                this.bots.put(id, new JunkTankBot(this.objects.get(id).getModel(), this.map.getModel()));
                break;
            }
            case "LongTurretBot": {
                this.bots.put(id, new LongTurretBot(this.objects.get(id).getModel(), this.map.getModel()));
                break;
            }
            case "TankBot": {
                if (options.length == 0) {
                    this.bots.put(id, new TankBot(this.objects.get(id).getModel(), this.map.getModel()));
                    break;
                }
                this.bots.put(id, new TankBot(this.objects.get(id).getModel(), this.map.getModel(), Double.parseDouble(options[0]), Double.parseDouble(options[1])));
                break;
            }
            case "RaceBot": {
                this.bots.put(id, new RaceBot(this.objects.get(id).getModel(), this.map.getModel()));
                break;
            }
            case "BattleRaceBot": {
                this.bots.put(id, new BattleRaceBot(this.objects.get(id).getModel(), this.map.getModel()));
                break;
            }
            case "AirBot": {
                this.bots.put(id, new AirBot(this.objects.get(id).getModel(), this.map.getModel()));
                break;
            }
            case "AirBattleBot": {
                this.bots.put(id, new AirBattleBot(this.objects.get(id).getModel(), this.map.getModel()));
                break;
            }
            default: {
                throw new MachineProgram.ProgramException("[Runtime error] unknown bot name : " + value, -1);
            }
        }
    }

    private static Bound getBound(ProgramNode context) throws MachineProgram.ProgramException {
        Bound b = new Bound();
        MutVector p1 = new MutVector().set(context.getVariable("x", -1).getValue(), context.getVariable("y", -1).getValue(), context.getVariable("z", -1).getValue());
        MutVector p2 = new MutVector().set(context.getVariable("w", -1).getValue(), context.getVariable("h", -1).getValue(), context.getVariable("d", -1).getValue()).add(p1);
        b.set(p1);
        b.set(p2);
        return b;
    }

    private Machine getObjectById(int id) throws MachineProgram.ProgramException {
        if (this.playerMachines.containsKey(id)) {
            return this.playerMachines.get(id);
        }
        if (this.objects.containsKey(id)) {
            return this.objects.get(id);
        }
        throw new MachineProgram.ProgramException("[Runtime error] object id " + id + " not found", -1);
    }

    @Override
    public void accept(List<Machine> playerList, Consumer<String> printer) {
        this.printer = printer;
        this.updatePlayerCollection(playerList);
        this.computeBots();
        this.playerMachines.entrySet().stream().filter(e -> ((Machine)e.getValue()).getAction()).forEach(e -> {
            try {
                FunDecNode fun = this.program.getFunction("action(1)", -1);
                fun.setArgument(0, ((Integer)e.getKey()).intValue());
                fun.execute();
            }
            catch (MachineProgram.ProgramException e1) {
                e1.printStackTrace();
            }
        });
        if (playerList.size() > 0) {
            try {
                this.program.launch();
            }
            catch (MachineProgram.ProgramException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void updatePlayerCollection(List<Machine> playerList) {
        playerList.stream().forEach(m -> {
            if (!this.playerMachines.containsKey(m.getModel().id)) {
                m.setCanRestart(this.restartable);
                this.teams.put(m.getModel().id, -1);
                this.playerMachineIds.add(m.getModel().id);
                this.playerMachines.put(m.getModel().id, (Machine)m);
            }
        });
        this.playerMachines.values().retainAll(playerList);
        this.playerMachineIds.retainAll(this.playerMachines.keySet());
        this.teams.keySet().removeIf(id -> !this.playerMachines.containsKey(id) && !this.objects.containsKey(id));
    }

    private void computeBots() {
        this.bots.keySet().retainAll(this.objects.keySet());
        this.bots.entrySet().stream().forEach(e -> {
            Machine machine = this.objects.get(e.getKey());
            if (machine.getRemainEndurance() > 0.0) {
                Bot bot = (Bot)e.getValue();
                bot.clearEnemy();
                Integer team = this.teams.getOrDefault(e.getKey(), -1);
                Stream.concat(this.playerMachines.entrySet().stream(), this.objects.entrySet().stream()).filter(e1 -> !((Integer)e.getKey()).equals(e1.getKey())).filter(e1 -> this.teams.containsKey(e1.getKey())).filter(e1 -> ((Machine)e1.getValue()).getRemainEndurance() > 0.0).forEach(e1 -> {
                    if (team.equals(this.teams.get(e1.getKey()))) {
                        bot.addFriend(((Machine)e1.getValue()).getModel());
                    } else {
                        bot.addEnemy(((Machine)e1.getValue()).getModel());
                    }
                });
                bot.update();
                machine.setKeyState(bot.getKeyState());
                machine.setCameraAxis(bot.getCamera());
            }
        });
    }

    @Override
    public Vector getFirstPlace() {
        return this.startPlace;
    }

    @Override
    public Vector getFirstRotate() {
        return this.startRotate;
    }

    @Override
    public WorldObject make() {
        return this.map;
    }

    @Override
    public PhysicsObject[] makeObjects() {
        return new PhysicsObject[0];
    }

    @Override
    public MapProgram getProgram() {
        return this;
    }
}

