/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map;

import java.io.FileNotFoundException;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.InsideBoxShape;
import net.comp_lot.glui.model.utils.Bound;
import net.comp_lot.glui.system.utils.GridModelGroup;
import net.comp_lot.glui.system.utils.InFaceEdgeDetector;
import net.comp_lot.glui.system.utils.ObjParser;

public class ObjMap
implements MapBuilder {
    private final String file;

    public ObjMap(String file) {
        this.file = file;
    }

    @Override
    public Vector getFirstPlace() {
        return Vector.ZERO;
    }

    @Override
    public WorldObject make() {
        ModelGroup m = new ModelGroup();
        WorldObject wo = new WorldObject(m);
        try {
            ModelGroup obj = new ObjParser(this.file, TextureEnum.WHITE.getAsInfo()).getModel();
            obj = GridModelGroup.make(obj, 50.0);
            new InFaceEdgeDetector(obj).detectAndSet(0.25f, 0.5f, 0.05f);
            Bound bound = obj.getBound();
            InsideBoxShape wall = new InsideBoxShape((float)(bound.getMaxX() - bound.getMinX()), (float)(bound.getMaxY() - bound.getMinY() + 1024.0), (float)(bound.getMaxZ() - bound.getMinZ()), TextureEnum.FRAME.getAsInfo());
            wall.setOpaque(false);
            wall.setColor(-188);
            wall.moveP(bound.getCenter());
            m.addModels(obj, wall);
            m.fix();
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot read map file : \"" + this.file + "\"");
        }
        return wo;
    }
}

