/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.map;

import net.comp_lot.craftalos.map.MapBuilder;
import net.comp_lot.craftalos.map.ObjMap;
import net.comp_lot.craftalos.map.ProgramableMap;
import net.comp_lot.craftalos.map.map.AdventureMap1;
import net.comp_lot.craftalos.map.map.MiniRoboConMap;
import net.comp_lot.craftalos.map.map.RaceMap;
import net.comp_lot.craftalos.map.map.RoboConMap2022;
import net.comp_lot.craftalos.map.map.RoboConMapA2;
import net.comp_lot.craftalos.map.map.TutorialMap;
import net.comp_lot.craftalos.system.World;

public class MapBuilderFactory {
    public static MapBuilder create(String name, World world) {
        switch (name) {
            case "SimpleTestMap": {
                return new ObjMap("res/map/test_map.obj");
            }
            case "TestMap1": {
                return new AdventureMap1();
            }
            case "RoboConMap0": {
                return new RoboConMapA2();
            }
            case "MiniRoboConMap": {
                return new MiniRoboConMap();
            }
            case "RoboConMap2022": {
                return new ProgramableMap(new RoboConMap2022(), "res/map/robocon_map2022.bcp", world);
            }
            case "TutorialMap": {
                return new ProgramableMap(new TutorialMap(), "res/map/tutorial_map.bcp", world);
            }
            case "RaceMap": {
                return new RaceMap();
            }
        }
        String[] names = name.split(":");
        if (names.length == 2) {
            return new ProgramableMap(new ObjMap(names[0]), names[1], world);
        }
        return new ObjMap(name);
    }
}

