/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class SpeedSensorBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private final MutVector axis = new MutVector();

    public SpeedSensorBlock(String ident) {
        super(ident);
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(0, TextureEnum.FUNCTIONAL_SPEED.getAsInfo());
        ((BoxShape)this.getModel()).setTex(1, TextureEnum.FUNCTIONAL_SPEED.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
    }

    @Override
    public String getPrefix() {
        return "SENSOR_";
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    protected double getValue() {
        this.getModel().LocalToGlobal(this.axis, Vector.Z_AXIS);
        this.axis.reverse();
        return 100.0 * Vector.Dot(this.getPart().getMove(this.getCenter()), this.axis);
    }

    @Override
    public String getFactoryName() {
        return "SPEED SENSOR";
    }
}

