/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Bullet;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.game.model.WeaponBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class RailBlock
extends WeaponBlock {
    private static final int CORE_WEIGHT = 4;
    private static final int BARREL_WEIGHT = 4;
    private static final int CORE_ENDURANCE = 3;
    private static final int BARREL_ENDURANCE = 1;
    private final int length;

    public RailBlock(Machine machine, String ident, int len) {
        super(machine, ident, new MutVector().set(1.0, 1.0, (double)(len * 2) - 0.1));
        this.length = len;
        float[] vertex = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, len *= 2, 0.0f, 2.0f, len, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, len, 0.0f, 0.0f, len};
        this.setModel(new BoxShape(vertex, TextureEnum.WHITE.getAsInfo()));
        this.setCenterLocal(MutVector.iDivision(new MutVector().set(1.0, 1.0, 1.0), new MutVector().set(1.0, 1.0, this.length), this.length * 4, 4.0));
        Matrix tensor = new Matrix();
        tensor.add(PhysicsObject.getBoxTensor(2.0, 2.0, len, this.length * 4));
        tensor.add(PhysicsObject.getOffsetTensor(new MutVector().set(this.getCenterLocal(), new MutVector().set(1.0, 1.0, len / 2)), this.length * 4));
        tensor.add(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, 4.0));
        tensor.add(PhysicsObject.getOffsetTensor(new MutVector().set(this.getCenterLocal(), new MutVector().set(1.0, 1.0, 1.0)), 4.0));
        this.setTensor(tensor);
        this.setTexture(TextureEnum.WEAPON_RAIL.getAsInfo());
    }

    @Override
    public int getWeight() {
        return 4 + this.length * 4;
    }

    @Override
    public double getInitialEndurance() {
        return 3 + this.length * 1;
    }

    @Override
    protected boolean shot(Vector pos, MutVector axis) {
        Bullet bullet = this.getBullet(pos, axis.add(MutVector.random().resize(0.001)));
        if (this.getMachine().useEnergy(bullet.getKineticEnergy() * 0.25)) {
            this.shot(bullet, new Sound(SoundEnum.RAIL, pos, (float)(bullet.getKineticEnergy() * 0.02)));
            return true;
        }
        return false;
    }

    @Override
    public void writeInfo(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(this.getIdent());
        sb.append(",");
        sb.append(this.length);
        sb.append(",");
        this.writePlace(sb);
        sb.append(")");
    }

    @Override
    public double getSpeed() {
        return 5.0;
    }

    @Override
    public double getBulletWeight() {
        return 0.16 + (double)this.length * 0.135;
    }

    @Override
    public double getReloadSpeed() {
        return 0.75;
    }

    @Override
    public Bullet getBullet(Vector pos, Vector axis) {
        return new Bullet(pos, axis, this.getBulletWeight(), 1.0f, this.getMachine());
    }

    @Override
    public String getFactoryName() {
        return "RAIL " + this.length;
    }
}

