/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.ColorSettable;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.model.model.BoxShape;

public class NormalBlock
extends Block
implements ColorSettable {
    private static final ColorEnum[] COLOR = new ColorEnum[]{ColorEnum.WHITE, ColorEnum.BLACK, ColorEnum.RED, ColorEnum.GREEN, ColorEnum.BLUE, ColorEnum.PURPLE, ColorEnum.ORANGE, ColorEnum.YELLOW};
    private int weight;
    private final Type type;
    private String color;

    public NormalBlock(int type, int texY) {
        this.type = Type.getByValue(type);
        float[] vertex = this.init();
        this.setModel(new BoxShape(vertex, TextureEnum.WHITE.getAsInfo()));
        this.setTex(COLOR[texY].getRgba());
    }

    public NormalBlock(int type) {
        this(type, 2);
    }

    private float[] init() {
        int x = this.type.getDepth();
        int y = this.type.getHeight();
        int z = this.type.getWidth();
        this.weight = x * y * z / 4;
        float[] vertex = new float[]{0.0f, y, 0.0f, x, y, 0.0f, x, y, z, 0.0f, y, z, 0.0f, 0.0f, 0.0f, x, 0.0f, 0.0f, x, 0.0f, z, 0.0f, 0.0f, z};
        this.setCenterLocal(new MutVector().set((double)x / 2.0, (double)y / 2.0, (double)z / 2.0));
        this.setTensor(PhysicsObject.getBoxTensor(x, y, z, this.getWeight()));
        return vertex;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public double getInitialEndurance() {
        return this.weight * this.type.getHeight();
    }

    public void setColor(String color) {
        this.color = color;
        Color c = Color.decode(color);
        this.setTex(c.getRGB() << 8 | 0xFF);
    }

    public String getColor() {
        return this.color;
    }

    @Override
    public void setTex(int rgba) {
        this.color = String.format("#%06x", rgba >> 8 & 0xFFFFFF);
        this.getModel().setColor(rgba);
    }

    @Override
    public void setColorType(boolean opaque, boolean dark) {
        Color c = Color.decode(this.color);
        int rgba = c.getRGB() << 8 | 0xFF;
        this.getModel().setOpaque(opaque);
        this.getModel().setColor(opaque ? (dark ? ColorEnum.darker(rgba) : rgba) : ColorEnum.transparent(rgba));
    }

    @Override
    public String getFactoryName() {
        if (this.type.getHeight() == 2) {
            return "Normal " + this.type.width / 2 + "x" + this.type.depth / 2;
        }
        return "Half " + this.type.width / 2 + "x" + this.type.depth / 2;
    }

    @Override
    public void writeInfo(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(this.type.getValue());
        sb.append(",");
        if (this.color != null) {
            sb.append('\"');
            sb.append(this.color);
            sb.append('\"');
            sb.append(",");
        }
        this.writePlace(sb);
        sb.append(")");
    }

    private static enum Type {
        S_ONE(11),
        S_TWO(12),
        S_THREE(13),
        S_FOUR(14),
        S_SIX(16),
        S_EIGHT(18),
        W_ONE(21),
        W_TWO(22),
        W_THREE(23),
        W_FOUR(24),
        W_SIX(26),
        W_EIGHT(28),
        HS_ONE(31),
        HS_TWO(32),
        HS_THREE(33),
        HS_FOUR(34),
        HS_SIX(36),
        HS_EIGHT(38),
        HW_ONE(41),
        HW_TWO(42),
        HW_THREE(43),
        HW_FOUR(44),
        HW_SIX(46),
        HW_EIGHT(48);

        private final int value;
        private final int width;
        private final int depth;
        private final int height;
        private static final Map<Integer, Type> MAP;

        static {
            MAP = new HashMap<Integer, Type>();
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                MAP.put(t.value, t);
                ++n2;
            }
        }

        private Type(int value) {
            this.value = value;
            this.width = ((value / 10 - 1) % 2 + 1) * 2;
            this.depth = value % 10 * 2;
            this.height = value / 10 > 2 ? 1 : 2;
        }

        int getValue() {
            return this.value;
        }

        int getWidth() {
            return this.width;
        }

        int getDepth() {
            return this.depth;
        }

        int getHeight() {
            return this.height;
        }

        public static Type getByValue(int value) {
            return MAP.getOrDefault(value, S_ONE);
        }
    }
}

