/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class MouseAxisBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private final Machine machine;
    private final MutVector cameraAxis = new MutVector();
    private final MutVector axisZ = new MutVector();
    private final MutVector axisY = new MutVector();

    public MouseAxisBlock(Machine machine, String ident) {
        super(ident);
        this.machine = machine;
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(0, TextureEnum.FUNCTIONAL_MOUSE.getAsInfo());
        ((BoxShape)this.getModel()).setTex(1, TextureEnum.FUNCTIONAL_MOUSE.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
    }

    @Override
    public String getPrefix() {
        return "SENSOR_";
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    protected double getValue() {
        this.getModel().LocalToGlobal(this.axisZ, Vector.Z_AXIS);
        this.getModel().LocalToGlobal(this.axisY, Vector.Y_AXIS);
        this.axisZ.reverse().toOrthogonal(this.axisY);
        this.cameraAxis.set(this.machine.getCameraAxis()).toOrthogonal(this.axisY);
        return -Math.toDegrees(Vector.angle(this.axisZ, this.cameraAxis, this.axisY));
    }

    @Override
    public String getFactoryName() {
        return "MOUSE AXIS SENSOR";
    }
}

