/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.AbstractMotorBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class MotorBlock
extends AbstractMotorBlock {
    private static final double SPEED_VALTAGE_RATE = 100.0;
    private static final double SPEED_LOSS_RATE = 7500.0;
    private static final double POWER_RATE = 0.8999999999999999;
    private static final double INTERNAL_MOMENT = 500.0;
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private static final Vector FIX_POS_PARENT_L = new MutVector().set(1.0, 1.0, -1.0);
    private static final Vector FIX_VEC_PARENT_L = Vector.Z_AXIS;

    public MotorBlock(Machine machine, String ident, Part parent, Part child) {
        super(machine, ident, parent, child);
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(4, TextureEnum.FUNCTIONAL_MOTOR.getAsInfo());
        ((BoxShape)this.getModel()).setTex(5, TextureEnum.FUNCTIONAL_MOTOR.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    public double getInternalMoment() {
        return 500.0;
    }

    @Override
    protected double getPower(double voltage) {
        return voltage * 0.8999999999999999;
    }

    @Override
    protected double loss(double voltage, double speed) {
        return MotorBlock.loss2(voltage, speed) - speed * 100.0;
    }

    private static double loss2(double voltage, double speed) {
        return Math.signum(voltage) * Math.max(Math.abs(voltage) - speed * speed * speed * speed * 7500.0, 0.0);
    }

    @Override
    protected void calcParentFixPoint(MutVector fixPosParentG, MutVector fixVecParentG) {
        this.getModel().LocalToGlobalCoord(fixPosParentG, FIX_POS_PARENT_L);
        this.getModel().LocalToGlobal(fixVecParentG, FIX_VEC_PARENT_L);
    }

    @Override
    public String getFactoryName() {
        return "MOTOR";
    }
}

