/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Bullet;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.game.model.WeaponBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class MachineGunBlock
extends WeaponBlock {
    private static final int CORE_WEIGHT = 6;
    private static final int BARREL_WEIGHT = 6;
    private static final int CORE_ENDURANCE = 3;
    private static final int BARREL_ENDURANCE = 1;
    private static final int MAX_MAGAZINE = 30;
    private final int length;

    public MachineGunBlock(Machine machine, String ident, int len) {
        super(machine, ident, new MutVector().set(1.0, 1.0, (double)(len * 2) - 0.1));
        this.length = len;
        float[] vertex = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, len *= 2, 0.0f, 2.0f, len, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, len, 0.0f, 0.0f, len};
        this.setModel(new BoxShape(vertex, TextureEnum.WHITE.getAsInfo()));
        this.setCenterLocal(MutVector.iDivision(new MutVector().set(1.0, 1.0, 1.0), new MutVector().set(1.0, 1.0, this.length), this.length * 6, 6.0));
        Matrix tensor = new Matrix();
        tensor.add(PhysicsObject.getBoxTensor(2.0, 2.0, len, this.length * 6));
        tensor.add(PhysicsObject.getOffsetTensor(new MutVector().set(this.getCenterLocal(), new MutVector().set(1.0, 1.0, len / 2)), this.length * 6));
        tensor.add(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, 6.0));
        tensor.add(PhysicsObject.getOffsetTensor(new MutVector().set(this.getCenterLocal(), new MutVector().set(1.0, 1.0, 1.0)), 6.0));
        this.setTensor(tensor);
        this.setTexture(TextureEnum.WEAPON_RIFLE.getAsInfo());
    }

    @Override
    public int getWeight() {
        return 6 + this.length * 6;
    }

    @Override
    public double getInitialEndurance() {
        return 3 + this.length * 1;
    }

    @Override
    protected boolean shot(Vector pos, MutVector axis) {
        Bullet bullet = this.getBullet(pos, axis.add(MutVector.random().resize(0.0075)));
        if (this.getMachine().useEnergy(bullet.getKineticEnergy() * 0.25)) {
            this.shot(bullet, new Sound(SoundEnum.RIFLE, pos, (float)(bullet.getKineticEnergy() * 0.04)));
            return true;
        }
        return false;
    }

    @Override
    public void writeInfo(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(this.getIdent());
        sb.append(",");
        sb.append(this.length);
        sb.append(",");
        this.writePlace(sb);
        sb.append(")");
    }

    @Override
    public double getSpeed() {
        return 1.85 + 0.175 * (double)this.length;
    }

    @Override
    public double getBulletWeight() {
        return 0.25;
    }

    @Override
    public double getReloadSpeed() {
        return 0.67;
    }

    @Override
    public int getMaxMagazine() {
        return 30;
    }

    @Override
    public Bullet getBullet(Vector pos, Vector axis) {
        return new Bullet(pos, axis, this.getBulletWeight(), 1.0f, this.getMachine());
    }

    @Override
    public String getFactoryName() {
        return "MACHINE GUN " + this.length;
    }
}

