/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.utils.RayCast;

public class LinkBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private Part parent;
    private Part child;
    private Block targetBlock;
    private static final Vector FIX_POS_PARENT_L = new MutVector().set(1.0, 1.0, 0.01);
    private static final Vector FIX_VEC_PARENT_L = new MutVector().set(Vector.Z_AXIS).reverse();
    private Vector fixPosChildL;
    private Vector fixVecChildL;
    private final MutVector fixPosParentG = new MutVector();
    private final MutVector fixVecParentG = new MutVector();
    private final MutVector fixPosChildG = new MutVector();
    private final MutVector fixVecChildG = new MutVector();

    public LinkBlock(String ident) {
        super(ident);
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(4, TextureEnum.FUNCTIONAL_LINK.getAsInfo());
        ((BoxShape)this.getModel()).setTex(5, TextureEnum.FUNCTIONAL_LINK.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
    }

    private void init() {
        this.getModel().LocalToGlobalCoord(this.fixPosParentG, FIX_POS_PARENT_L);
        this.getModel().LocalToGlobal(this.fixVecParentG, FIX_VEC_PARENT_L);
        this.parent = this.getPart();
        RayCast cast = new RayCast(this.fixPosParentG, this.fixVecParentG, 0.02);
        RayCast.CastResult result = cast.cast(this.parent.getMachine().getModel());
        if (result == null) {
            return;
        }
        MutVector p = new MutVector();
        this.getModel().LocalToGlobalCoord(p, new MutVector().set(1.1, 1.1, 0.01));
        RayCast.CastResult r = new RayCast(p, this.fixVecParentG, 0.02).cast(this.parent.getMachine().getModel());
        if (r == null || result.shape != r.shape) {
            return;
        }
        this.getModel().LocalToGlobalCoord(p, new MutVector().set(0.9, 0.9, 0.01));
        RayCast.CastResult r2 = new RayCast(p, this.fixVecParentG, 0.02).cast(this.parent.getMachine().getModel());
        if (r2 == null || result.shape != r2.shape) {
            return;
        }
        this.child = (Part)result.shape.getOwner();
        this.targetBlock = this.child.getBlockByShape(result.shape);
        MutVector tmpPos = new MutVector();
        MutVector tmpVec = new MutVector();
        this.child.getModel().GlobalToLocalCoord(tmpPos, this.fixPosParentG);
        this.child.getModel().GlobalToLocal(tmpVec, this.fixVecParentG);
        this.fixPosChildL = tmpPos;
        this.fixVecChildL = tmpVec;
    }

    public void link() {
        if (this.parent == null) {
            this.init();
        }
        if (this.child == null) {
            return;
        }
        if (this.getRemainEndurance() <= 0.0 || this.targetBlock.getRemainEndurance() <= 0.0) {
            return;
        }
        this.getModel().LocalToGlobalCoord(this.fixPosParentG, FIX_POS_PARENT_L);
        this.getModel().LocalToGlobal(this.fixVecParentG, FIX_VEC_PARENT_L);
        this.child.getModel().LocalToGlobalCoord(this.fixPosChildG, this.fixPosChildL);
        this.child.getModel().LocalToGlobal(this.fixVecChildG, this.fixVecChildL);
        MutVector v = new MutVector().set(this.fixPosParentG, this.fixPosChildG).scale(0.25).add(this.parent.getNewMove(this.fixPosParentG), -1.0).add(this.child.getNewMove(this.fixPosChildG), 1.0).toOrthogonal(this.fixVecParentG);
        this.addForce(v);
    }

    private void addForce(MutVector v) {
        double pm = this.parent.getFakeWeight(new Force(this.fixPosParentG, v));
        double cm = this.child.getFakeWeight(new Force(this.fixPosChildG, v));
        v.scale(pm * cm / (pm + cm));
        this.child.addForce(new Force(this.fixPosChildG, new MutVector().set(v).reverse()));
        this.parent.addForce(new Force(this.fixPosChildG, v));
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    public String getPrefix() {
        return "LINK_";
    }

    @Override
    public String getFactoryName() {
        return "LINK";
    }
}

