/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import java.awt.Color;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.utils.RayCast;

public class LightSensorBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private final Machine machine;
    private final Vector posLocal;
    private final MutVector pos = new MutVector();
    private final MutVector axis = new MutVector();

    public LightSensorBlock(Machine machine, String ident) {
        super(ident);
        this.machine = machine;
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(4, TextureEnum.FUNCTIONAL_LIGHT.getAsInfo());
        ((BoxShape)this.getModel()).setTex(5, TextureEnum.FUNCTIONAL_LIGHT.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
        this.posLocal = new MutVector().set(this.getCenterLocal()).add(Vector.Z_AXIS, -1.01);
    }

    @Override
    public String getPrefix() {
        return "SENSOR_";
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    protected double getValue() {
        this.getModel().LocalToGlobal(this.axis, Vector.Z_AXIS);
        this.axis.reverse();
        this.getModel().LocalToGlobalCoord(this.pos, this.posLocal);
        RayCast cast = new RayCast(this.pos, this.axis, 200.0);
        RayCast.CastResult result = cast.cast(this.machine.getWorld().getModel());
        if (result == null) {
            return 0.0;
        }
        Color c = result.shape.getFaceColor(result.faceIndex);
        double d = 0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue();
        return d /= (result.dist + 1.0) * (result.dist + 1.0);
    }

    @Override
    public String getFactoryName() {
        return "LIGHT SENSOR";
    }
}

