/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class HorizontalBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private final MutVector axisZ = new MutVector();
    private final MutVector axisY = new MutVector();
    private final MutVector axisGY = new MutVector();

    public HorizontalBlock(Machine machine, String ident) {
        super(ident);
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(4, TextureEnum.FUNCTIONAL_HORIZONTAL.getAsInfo());
        ((BoxShape)this.getModel()).setTex(5, TextureEnum.FUNCTIONAL_HORIZONTAL.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
    }

    @Override
    public String getPrefix() {
        return "SENSOR_";
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    protected double getValue() {
        this.getModel().LocalToGlobal(this.axisZ, Vector.Z_AXIS);
        this.getModel().LocalToGlobal(this.axisY, Vector.Y_AXIS);
        return -Math.toDegrees(Vector.angle(this.axisY, this.axisGY.set(Vector.Y_AXIS).toOrthogonal(this.axisZ), this.axisZ));
    }

    @Override
    public String getFactoryName() {
        return "HORIZONTAL SENSOR";
    }
}

