/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Bullet;
import net.comp_lot.craftalos.game.entity.GrenadeBullet;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.game.model.WeaponBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class GrenadeBlock
extends WeaponBlock {
    private static final int CORE_WEIGHT = 10;
    private static final int BARREL_WEIGHT = 7;
    private static final int CORE_ENDURANCE = 6;
    private static final double BARREL_ENDURANCE = 2.0;
    private final int length;

    public GrenadeBlock(Machine machine, String ident, int len) {
        super(machine, ident, new MutVector().set(1.0, 2.0, (double)(len * 2) - 0.1));
        this.length = len;
        float[] vertex = new float[]{0.0f, 4.0f, 0.0f, 2.0f, 4.0f, 0.0f, 2.0f, 4.0f, len *= 2, 0.0f, 4.0f, len, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, len, 0.0f, 0.0f, len};
        this.setModel(new BoxShape(vertex, TextureEnum.WHITE.getAsInfo()));
        this.setCenterLocal(MutVector.iDivision(new MutVector().set(1.0, 2.0, 1.0), new MutVector().set(1.0, 2.0, this.length), this.length * 7, 10.0));
        Matrix tensor = new Matrix();
        tensor.add(PhysicsObject.getBoxTensor(2.0, 4.0, len, this.length * 7));
        tensor.add(PhysicsObject.getOffsetTensor(new MutVector().set(this.getCenterLocal(), new MutVector().set(1.0, 2.0, len / 2)), this.length * 7));
        tensor.add(PhysicsObject.getBoxTensor(2.0, 4.0, 2.0, 10.0));
        tensor.add(PhysicsObject.getOffsetTensor(new MutVector().set(this.getCenterLocal(), new MutVector().set(1.0, 2.0, 1.0)), 10.0));
        this.setTensor(tensor);
        this.setTexture(TextureEnum.WEAPON_GRENADE.getAsInfo());
    }

    @Override
    public int getWeight() {
        return 10 + this.length * 7;
    }

    @Override
    public double getInitialEndurance() {
        return 6.0 + (double)this.length * 2.0;
    }

    @Override
    protected boolean shot(Vector pos, MutVector axis) {
        Bullet bullet = this.getBullet(pos, axis.add(MutVector.random().resize(0.01)));
        if (this.getMachine().useEnergy((20.0 + bullet.getKineticEnergy()) * 0.25)) {
            this.shot(bullet, new Sound(SoundEnum.GRENADE, pos, (float)(bullet.getKineticEnergy() * 0.03)));
            return true;
        }
        return false;
    }

    @Override
    public void writeInfo(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(this.getIdent());
        sb.append(",");
        sb.append(this.length);
        sb.append(",");
        this.writePlace(sb);
        sb.append(")");
    }

    @Override
    public double getSpeed() {
        return 0.1 + 0.175 * (double)this.length;
    }

    @Override
    public double getBulletWeight() {
        return 20.0;
    }

    @Override
    public double getReloadSpeed() {
        return 0.55 + 0.07 * (double)this.length;
    }

    @Override
    public Bullet getBullet(Vector pos, Vector axis) {
        return new GrenadeBullet(pos, axis, this.getBulletWeight(), this.getMachine());
    }

    @Override
    public String getFactoryName() {
        return "GRENADE " + this.length;
    }
}

