/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.model.model.BoxShape;

public class FcsBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private final Machine machine;

    public FcsBlock(Machine machine, String ident) {
        super(ident);
        this.machine = machine;
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(4, TextureEnum.FUNCTIONAL_FCS.getAsInfo());
        ((BoxShape)this.getModel()).setTex(5, TextureEnum.FUNCTIONAL_FCS.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
    }

    @Override
    protected void setValue(double value) {
        if (value != 0.0) {
            this.machine.setFcsEnable(true);
        }
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    public String getPrefix() {
        return "FCS_";
    }

    @Override
    public void writeInfo(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(this.getIdent());
        sb.append(",");
        this.writePlace(sb);
        sb.append(")");
    }

    @Override
    public String getFactoryName() {
        return "FCS";
    }
}

