/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.utils.RayCast;

public class DistanceSensorBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private final Machine machine;
    private final Vector posLocal;
    private final MutVector pos = new MutVector();
    private final MutVector axis = new MutVector();

    public DistanceSensorBlock(Machine machine, String ident) {
        super(ident);
        this.machine = machine;
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(4, TextureEnum.FUNCTIONAL_DISTANCE.getAsInfo());
        ((BoxShape)this.getModel()).setTex(5, TextureEnum.FUNCTIONAL_DISTANCE.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
        this.posLocal = new MutVector().set(this.getCenterLocal()).add(Vector.Z_AXIS, -1.01);
    }

    @Override
    public String getPrefix() {
        return "SENSOR_";
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    protected double getValue() {
        this.getModel().LocalToGlobal(this.axis, Vector.Z_AXIS);
        this.axis.reverse();
        this.getModel().LocalToGlobalCoord(this.pos, this.posLocal);
        RayCast cast = new RayCast(this.pos, this.axis, 20000.0);
        RayCast.CastResult result = cast.cast(this.machine.getWorld().getModel());
        if (result == null) {
            return -1.0;
        }
        return result.dist * 0.5;
    }

    @Override
    public String getFactoryName() {
        return "DISTANCE SENSOR";
    }
}

