/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model.parts;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.model.BoxShape;

public class CameraBlock
extends FunctionalBlock {
    private static final float[] SHAPE = new float[]{0.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f, 0.0f, 2.0f};
    private final Machine machine;
    private final Vector posLocal;
    private final MutVector pos = new MutVector();
    private final MutVector axis = new MutVector();
    private final MutVector axisBuf = new MutVector();
    private final MutVector top = new MutVector();
    private final MutVector topBuf = new MutVector();

    public CameraBlock(Machine machine, String ident) {
        super(ident);
        this.machine = machine;
        this.setModel(new BoxShape(SHAPE, TextureEnum.FUNCTIONAL.getAsInfo()));
        ((BoxShape)this.getModel()).setTex(4, TextureEnum.FUNCTIONAL_CAMERA.getAsInfo());
        ((BoxShape)this.getModel()).setTex(5, TextureEnum.FUNCTIONAL_CAMERA.getAsInfo());
        this.setCenterLocal(new MutVector().set(1.0, 1.0, 1.0));
        this.setTensor(PhysicsObject.getBoxTensor(2.0, 2.0, 2.0, this.getWeight()));
        this.posLocal = new MutVector().set(this.getCenterLocal()).add(Vector.Z_AXIS, -0.5);
    }

    @Override
    protected void setValue(double value) {
        if (value != 0.0) {
            this.getModel().LocalToGlobalCoord(this.pos, this.posLocal);
            this.getModel().LocalToGlobal(this.axis, Vector.Z_AXIS);
            this.axis.reverse();
            this.getModel().LocalToGlobal(this.top, Vector.Y_AXIS);
            this.axisBuf.scale(1.0).add(this.axis).scale(0.5);
            this.topBuf.scale(1.0).add(this.top).scale(0.5);
            this.machine.setCamera(this.pos, this.axisBuf, this.topBuf);
        }
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public double getInitialEndurance() {
        return 4.0;
    }

    @Override
    public String getPrefix() {
        return "CAMERA_";
    }

    @Override
    public String getFactoryName() {
        return "CAMERA";
    }
}

