/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Bullet;
import net.comp_lot.craftalos.game.entity.BulletPredict;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.TextureInfo;
import net.comp_lot.glui.model.model.BoxShape;

public abstract class WeaponBlock
extends FunctionalBlock {
    private final Machine machine;
    private boolean fire = false;
    private int magazine = 0;
    private double interval = 1.0;
    private double reload = 1.0;
    private final Vector posLocal;
    private final MutVector pos = new MutVector();
    private final MutVector axis = new MutVector();
    private BulletPredict predict = null;

    protected WeaponBlock(Machine machine, String ident, Vector posLocal) {
        super(ident);
        this.machine = machine;
        this.posLocal = posLocal;
    }

    protected void setTexture(TextureInfo sideTex) {
        int i = 0;
        while (i < 12) {
            ((BoxShape)this.getModel()).setTex(i, TextureEnum.WEAPON.getAsInfo());
            ++i;
        }
        ((BoxShape)this.getModel()).setTex(8, TextureEnum.WEAPON_MUZZLE.getAsInfo());
        ((BoxShape)this.getModel()).setTex(9, TextureEnum.WEAPON_MUZZLE.getAsInfo());
        ((BoxShape)this.getModel()).setTex(6, sideTex);
        ((BoxShape)this.getModel()).setTex(7, sideTex);
        ((BoxShape)this.getModel()).setTex(10, sideTex);
        ((BoxShape)this.getModel()).setTex(11, sideTex);
    }

    @Override
    protected void setValue(double value) {
        this.fire = value != 0.0;
    }

    @Override
    protected double getValue() {
        return this.magazine != 0 ? (double)this.magazine : this.reload;
    }

    public abstract double getSpeed();

    public abstract double getBulletWeight();

    public abstract double getReloadSpeed();

    public int getMaxMagazine() {
        return 1;
    }

    public abstract Bullet getBullet(Vector var1, Vector var2);

    protected abstract boolean shot(Vector var1, MutVector var2);

    protected void shot(Bullet bullet, Sound sound) {
        this.getMachine().addEntity(bullet);
        this.getMachine().addEntity(sound);
        this.getPart().addForce(new Force(this.getCenter(), new MutVector().set(this.axis).resize(-bullet.getKineticEnergy())));
    }

    @Override
    public String getPrefix() {
        return "WEAPON_";
    }

    @Override
    public void update() {
        if (this.isAlive() && this.machine.isFcsEnable()) {
            if (this.predict == null) {
                this.predict = new BulletPredict(this.getMachine());
                this.getMachine().addEntity(this.predict);
            }
            this.getModel().LocalToGlobalCoord(this.pos, this.posLocal);
            this.getModel().LocalToGlobal(this.axis, Vector.Z_AXIS);
            this.predict.set(this.pos, this.axis.resize(this.getSpeed()).add(this.getPart().getMove(this.pos), 0.5));
        } else if (this.predict != null) {
            this.predict.disable();
            this.predict = null;
        }
        if (this.magazine != this.getMaxMagazine() && this.reload >= 1.0) {
            this.magazine = this.getMaxMagazine();
            this.reload = 0.0;
        }
        this.reload = Math.min(this.reload + this.getReloadSpeed() * 0.0033333333333333335, 1.0);
        this.interval = Math.min(this.interval + 0.2, 1.0);
        if (this.isAlive() && this.fire && this.magazine >= 1 && this.interval == 1.0) {
            this.getModel().LocalToGlobalCoord(this.pos, this.posLocal);
            this.getModel().LocalToGlobal(this.axis, Vector.Z_AXIS);
            if (this.shot(this.pos, this.axis.resize(this.getSpeed()).add(this.getPart().getMove(this.pos), 0.5))) {
                --this.magazine;
                this.reload = 0.0;
                this.interval = 0.0;
            }
        }
        this.fire = false;
    }
}

