/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.phisics.Connection;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Face;
import net.comp_lot.glui.model.utils.Bound;

public abstract class ConnectionBlock
extends FunctionalBlock
implements Connection {
    protected final Machine machine;
    protected final Part parent;
    protected final Part child;

    public ConnectionBlock(Machine root, String ident, Part parent, Part child) {
        super(ident);
        this.machine = root;
        this.parent = parent;
        this.child = child;
        child.setConnection(this);
    }

    public Part getChild() {
        return this.child;
    }

    @Override
    protected void onDestroy() {
        this.child.destroy();
    }

    @Override
    public boolean isAdjacent(Block block) {
        if (this.getPart() == block.getPart()) {
            return super.isAdjacent(block);
        }
        int i = 0;
        while (i < this.getModel().getFacesNum()) {
            if (this.isConnectionFace(i)) {
                Bound bound = new Bound();
                bound.addBound(this.getModel().getBound());
                bound.expand(-0.25);
                Face face = this.getModel().getFacesArray()[i];
                MutVector v = new MutVector().set(face.getA()).add(face.getB()).add(face.getC()).scale(0.3333333333333333).add(face.getNormal(), 0.25);
                bound.set(v);
                if (bound.crossing(block.getModel().getBound())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public abstract Vector getConnectionPoint();

    public abstract boolean isConnectionFace(int var1);

    public abstract void setCollidability();
}

