/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.MachineProperty;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.phisics.PhysicsProperty;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.utils.Bound;

public abstract class Block
implements PhysicsProperty,
MachineProperty {
    private Part parent;
    private Shape model;
    private Matrix tensor;
    private Vector gCenterLocal;
    private MutVector gCenterGlobal = new MutVector();
    private double endurance = 1.0;
    private final List<Block> adjacents = new ArrayList<Block>();
    private boolean connected;

    public Shape getModel() {
        return this.model;
    }

    public Part getPart() {
        if (this.parent != null) {
            return this.parent;
        }
        return (Part)this.model.getOwner();
    }

    public Machine getMachine() {
        if (this.getPart() == null) {
            return null;
        }
        return this.getPart().getMachine();
    }

    protected void setModel(Shape model) {
        this.model = model;
    }

    @Override
    public final double getRemainEndurance() {
        return this.endurance;
    }

    @Override
    public final void setEndurance(double endurance) {
        this.endurance = endurance;
        if (this.model.isVisible() && endurance == 0.0) {
            this.model.setHasCollider(false);
            this.model.setVisible(false);
            this.getMachine().printGlobal(String.format("!destruct %d false", this.model.id));
            this.onDestroy();
        } else if (!this.model.isVisible() && endurance > 0.0) {
            this.model.setHasCollider(true);
            this.model.setVisible(true);
            this.getMachine().printGlobal(String.format("!destruct %d true", this.model.id));
        }
    }

    protected void onDestroy() {
    }

    @Override
    public void resetEndurance() {
        this.setEndurance(this.getInitialEndurance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double damage(double damage) {
        if (this.getMachine().isSolid()) {
            return 0.0;
        }
        Machine machine = this.getMachine();
        synchronized (machine) {
            block5: {
                if (!(this.endurance - damage > 0.0)) break block5;
                this.setEndurance(this.endurance - damage);
                return 0.0;
            }
            this.setEndurance(0.0);
            return damage -= this.endurance;
        }
    }

    public void damagePropagation(double damage) {
        if (this.getMachine().isSolid()) {
            return;
        }
        LinkedList<Block> blocks = new LinkedList<Block>();
        blocks.add(this);
        while (blocks.stream().anyMatch(b -> b.isAlive())) {
            for (Block b2 : blocks) {
                if (!b2.isAlive() || !((damage = b2.damage(damage)) <= 0.0)) continue;
                return;
            }
            int blocksSize = blocks.size();
            int i = 0;
            while (i < blocksSize) {
                for (Block a : ((Block)blocks.remove((int)0)).adjacents) {
                    if (!a.isAlive()) continue;
                    blocks.add(a);
                }
                ++i;
            }
        }
    }

    protected void setTensor(Matrix tensor) {
        this.tensor = tensor;
    }

    protected void setCenterLocal(Vector gCenterLocal) {
        this.gCenterLocal = gCenterLocal;
    }

    protected Vector getCenterLocal() {
        return this.gCenterLocal;
    }

    public abstract void setColorType(boolean var1, boolean var2);

    public abstract void writeInfo(StringBuilder var1);

    protected void writePlace(StringBuilder sb) {
        MutVector buf = new MutVector();
        this.getModel().LocalToParent(buf, Vector.X_AXIS);
        sb.append(buf);
        sb.append(", ");
        this.getModel().LocalToParent(buf, Vector.Y_AXIS);
        sb.append(buf);
        sb.append(", ");
        this.getModel().LocalToParent(buf, Vector.Z_AXIS);
        sb.append(buf);
        sb.append(", ");
        this.getModel().LocalToParentCoord(buf, Vector.ZERO);
        sb.append(buf);
    }

    @Override
    public void computeCenter() {
        this.getModel().LocalToGlobalCoord(this.gCenterGlobal, this.gCenterLocal);
    }

    @Override
    public Vector getCenter() {
        return this.gCenterGlobal;
    }

    @Override
    public Matrix getTensor() {
        Matrix r = this.getModel().getRotationMatrix();
        return Matrix.product(Matrix.product(r, this.tensor), r.getTranspose());
    }

    public void cacheParent() {
        this.parent = this.getPart();
    }

    public void addIfAdjacent(Block block) {
        if (this.isAdjacent(block)) {
            this.adjacents.add(block);
        }
    }

    public boolean isAdjacent(Block block) {
        Bound bx = new Bound();
        bx.addBound(this.getModel().getBound());
        bx.expand(-0.25);
        bx.expandX(0.5);
        Bound by = new Bound();
        by.addBound(this.getModel().getBound());
        by.expand(-0.25);
        by.expandY(0.5);
        Bound bz = new Bound();
        bz.addBound(this.getModel().getBound());
        bz.expand(-0.25);
        bz.expandZ(0.5);
        return bx.crossing(block.getModel().getBound()) || by.crossing(block.getModel().getBound()) || bz.crossing(block.getModel().getBound());
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void setConnectedRec() {
        if (!this.isAlive()) {
            return;
        }
        this.connected = true;
        this.adjacents.stream().filter(b -> !b.connected).forEach(b -> b.setConnectedRec());
    }

    public void destroyIfNotConnected() {
        if (!this.connected) {
            this.setEndurance(0.0);
        }
    }

    public abstract String getFactoryName();
}

