/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.model;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.phisics.Connection;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.craftalos.phisics.Torque;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.utils.Bound;

public abstract class AbstractMotorBlock
extends ConnectionBlock {
    private static final double VOLTAGE_CAP = 80.0;
    private static final double VOLTAGE_CAP2 = 100.0;
    private Vector fixPosChildL;
    private Vector fixVecChildL;
    private final MutVector fixPosParentG = new MutVector();
    private final MutVector fixVecParentG = new MutVector();
    private final MutVector fixPosChildG = new MutVector();
    private final MutVector fixVecChildG = new MutVector();
    private Vector childXAxisL;
    private final MutVector childXAxisG = new MutVector();
    private final MutVector parentXAxisG = new MutVector();
    private final MutVector parentYAxisG = new MutVector();
    private final MutVector fixPointToCenterG = new MutVector();
    private double voltage = 0.0;

    public AbstractMotorBlock(Machine machine, String ident, Part parent, Part child) {
        super(machine, ident, parent, child);
    }

    @Override
    public String getPrefix() {
        return "MOTOR_";
    }

    @Override
    public void calcFixPoint() {
        this.calcParentFixPoint();
        if (this.fixVecChildL == null || this.fixPosChildL == null) {
            this.initFixPoint();
        }
        this.child.getModel().LocalToGlobalCoord(this.fixPosChildG, this.fixPosChildL);
        this.child.getModel().LocalToGlobal(this.fixVecChildG, this.fixVecChildL);
        this.fixPointToCenterG.set(this.fixPosParentG, this.child.getCenter()).toOrthogonal(this.fixVecParentG);
    }

    @Override
    public void calcParentFixPoint() {
        this.calcParentFixPoint(this.fixPosParentG, this.fixVecParentG);
    }

    protected abstract void calcParentFixPoint(MutVector var1, MutVector var2);

    void initFixPoint() {
        MutVector fixPosChildL = new MutVector();
        MutVector fixVecChildL = new MutVector();
        this.child.getModel().GlobalToLocalCoord(fixPosChildL, this.fixPosParentG);
        this.child.getModel().GlobalToLocal(fixVecChildL, this.fixVecParentG);
        this.fixPosChildL = fixPosChildL;
        this.fixVecChildL = fixVecChildL;
        MutVector childXAxisL = new MutVector();
        this.getModel().LocalToGlobal(this.parentXAxisG, Vector.X_AXIS);
        this.child.getModel().GlobalToLocal(childXAxisL, this.parentXAxisG);
        this.childXAxisL = childXAxisL;
    }

    @Override
    public void keepConnection() {
        double size = Vector.Dot(this.child.getRotationBuf(), this.fixVecParentG);
        this.child.setRotationBuf(new MutVector().set(this.fixVecParentG).resize(size));
        MutVector buf = new MutVector().set(this.fixPosChildG).rotate(this.child.getCenter(), this.fixVecParentG, size);
        this.child.setMoveBuf(buf.set(buf, this.fixPosParentG));
    }

    @Override
    public Connection.SplitedTorqueForce splitForce(Force force) {
        MutVector r = new MutVector().set(this.fixPosParentG, force.getPoint()).toOrthogonal(this.fixVecParentG);
        if (r.getSize() > 0.0) {
            MutVector cForce = new MutVector().set(force.getForce());
            cForce.toOrthogonal(r).toOrthogonal(this.fixVecParentG);
            MutVector cTorque = MutVector.Cross(r, cForce);
            if (cTorque.getSize() > 0.0) {
                double nf = cTorque.getSize() * this.fixPointToCenterG.getSize() * (double)this.child.getWeight() / this.child.getMoment(this.child.getCenter(), cTorque);
                if (nf < cForce.getSize()) {
                    cForce.resize(nf);
                }
                MutVector pTorque = r.set(cTorque).reverse();
                return new Connection.SplitedTorqueForce(new Force(force.getPoint(), force.getForce()), new Force(this.child.getCenter(), cForce), new Torque(pTorque), cTorque);
            }
        }
        return new Connection.SplitedTorqueForce(force, null, null, null);
    }

    @Override
    public Connection.SplitedTorqueForce splitTorque(Torque torque) {
        MutVector tp = new MutVector().set(torque.getTorque()).toOrthogonal(this.fixVecParentG);
        return new Connection.SplitedTorqueForce(null, null, new Torque(tp), torque.getTorque().toParallel(this.fixVecParentG));
    }

    @Override
    public void calcFunction() {
        double speed = Vector.Dot(this.child.getRotationBuf(), this.fixVecParentG);
        this.calcTorque(speed);
    }

    private void calcTorque(double speed) {
        double v;
        double d = v = this.voltage != 0.0 ? this.loss(this.voltage, speed) : 0.0 - speed;
        if (v < -100.0) {
            v = -100.0;
        }
        if (v > 100.0) {
            v = 100.0;
        }
        if (this.machine.useEnergy(Math.abs(this.voltage) * (1.0 + Math.abs(speed)) * 5.5E-4)) {
            double m = this.child.getMoment(this.fixPosParentG, this.fixVecParentG);
            MutVector vec = new MutVector().set(this.fixVecParentG).resize(this.getPower(v));
            this.parent.addTorque(new Torque(new MutVector().set(vec).scale(-(m - this.getInternalMoment()) / m)));
            this.child.addTorque(new Torque(vec));
            if (Math.abs(this.voltage) > 10.0 && Math.random() < 0.01) {
                this.machine.addEntity(new Sound(SoundEnum.MOTOR, this.fixPosParentG, (float)Math.abs(this.voltage / 80.0)));
            }
        }
    }

    public abstract double getInternalMoment();

    protected abstract double getPower(double var1);

    protected abstract double loss(double var1, double var3);

    @Override
    protected double getValue() {
        double value = this.getValueSub();
        return Math.toDegrees(value > Math.PI ? value - Math.PI * 2 : value);
    }

    private double getValueSub() {
        this.getModel().LocalToGlobal(this.parentXAxisG, Vector.X_AXIS);
        this.getModel().LocalToGlobal(this.parentYAxisG, Vector.Y_AXIS);
        this.child.getModel().LocalToGlobal(this.childXAxisG, this.childXAxisL);
        double angleX = Vector.angle(this.parentXAxisG, this.childXAxisG);
        double angleY = Vector.angle(this.parentYAxisG, this.childXAxisG);
        if (angleX < 1.5707963267948966 && angleY < 1.5707963267948966) {
            return angleX;
        }
        if (angleY < angleX) {
            return angleY + 1.5707963267948966;
        }
        return Math.PI * 2 - angleX;
    }

    @Override
    protected void setValue(double v) {
        this.voltage = v > 80.0 ? 80.0 : (v < -80.0 ? -80.0 : v);
    }

    @Override
    public Vector getConnectionPoint() {
        return this.fixPosParentG;
    }

    @Override
    public boolean isConnectionFace(int face) {
        return face == 4 || face == 5;
    }

    @Override
    public void setCollidability() {
        Bound pBound = this.parent.getBlockModel().getBound();
        Bound cBound = this.child.getBlockModel().getBound();
        if (this.fixVecParentG.getX() != 0.0) {
            this.setCollidability(pBound.getMinX(), pBound.getMaxX(), cBound.getMinX(), cBound.getMaxX());
        }
        if (this.fixVecParentG.getY() != 0.0) {
            this.setCollidability(pBound.getMinY(), pBound.getMaxY(), cBound.getMinY(), cBound.getMaxY());
        }
        if (this.fixVecParentG.getZ() != 0.0) {
            this.setCollidability(pBound.getMinZ(), pBound.getMaxZ(), cBound.getMinZ(), cBound.getMaxZ());
        }
    }

    private void setCollidability(double pMin, double pMax, double cMin, double cMax) {
        this.child.setCollidableWithParent(!(cMax < pMin + 0.2) && !(cMin > pMax - 0.2));
    }
}

