/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.craftalos.CraftalosConfig;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.sound.AudioSystem;

public class Sound
extends Entity {
    private int soundId;
    private float volume = 1.0f;
    private int remainTime;

    public Sound(SoundEnum sound, Vector pos, float volume) {
        super(Entity.Type.SOUND);
        this.soundId = sound.getId();
        this.volume = volume;
        this.pos.set(pos);
        this.remainTime = 20;
    }

    public Sound(int id) {
        super(id, Entity.Type.SOUND);
    }

    public void play(AudioSystem audioSystem, CraftalosConfig config) {
        audioSystem.playSound(this.soundId, this.getPos(), Vector.ZERO, this.volume * config.getVolumeSe(), false);
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
        this.soundId = s.readInt();
        this.volume = s.readFloat();
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
        s.writeInt(this.soundId);
        s.writeFloat(this.volume);
    }

    @Override
    public void update(Model world, EntityParent parent) {
        --this.remainTime;
    }

    @Override
    public boolean isEnable() {
        return this.remainTime > 0;
    }

    @Override
    public Model getModel() {
        return null;
    }

    @Override
    protected Entity clone(int id) {
        Sound s = new Sound(id);
        s.soundId = this.soundId;
        s.volume = this.volume;
        return s;
    }
}

