/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.entity;

import java.util.List;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.entity.Bullet;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.game.entity.Explode;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.utils.RayCast;

public class GrenadeBullet
extends Bullet {
    private static final List<Vector> VECTOR = List.of(new MutVector().set(0.26967, 0.76967, 0.57869), new MutVector().set(0.76967, 0.57869, 0.26967), new MutVector().set(0.57869, 0.26967, 0.76967), new MutVector().set(0.57735, 0.57735, 0.57735), new MutVector().set(0.0, 0.66667, 0.74536), new MutVector().set(0.30902, 0.16667, 0.93634), new MutVector().set(-0.30902, 0.16667, 0.93634), new MutVector().set(0.0, 0.35682, 0.93417), new MutVector().set(-0.26967, 0.76967, 0.57869), new MutVector().set(-0.57869, 0.26967, 0.76967), new MutVector().set(-0.76967, 0.57869, 0.26967), new MutVector().set(-0.57735, 0.57735, 0.57735), new MutVector().set(-0.16667, 0.93634, 0.30902), new MutVector().set(-0.66667, 0.74536, 0.0), new MutVector().set(-0.16667, 0.93634, -0.30902), new MutVector().set(-0.35682, 0.93417, 0.0), new MutVector().set(0.16667, 0.93634, -0.30902), new MutVector().set(0.66667, 0.74536, 0.0), new MutVector().set(0.16667, 0.93634, 0.30902), new MutVector().set(0.35682, 0.93417, 0.0), new MutVector().set(-0.26967, 0.76967, -0.57869), new MutVector().set(-0.76967, 0.57869, -0.26967), new MutVector().set(-0.57869, 0.26967, -0.76967), new MutVector().set(-0.57735, 0.57735, -0.57735), new MutVector().set(0.0, 0.66667, -0.74536), new MutVector().set(-0.30902, 0.16667, -0.93634), new MutVector().set(0.30902, 0.16667, -0.93634), new MutVector().set(0.0, 0.35682, -0.93417), new MutVector().set(0.26967, 0.76967, -0.57869), new MutVector().set(0.57869, 0.26967, -0.76967), new MutVector().set(0.76967, 0.57869, -0.26967), new MutVector().set(0.57735, 0.57735, -0.57735), new MutVector().set(0.74536, 0.0, -0.66667), new MutVector().set(0.93634, -0.30902, -0.16667), new MutVector().set(0.93634, 0.30902, -0.16667), new MutVector().set(0.93417, 0.0, -0.35682), new MutVector().set(0.74536, 0.0, 0.66667), new MutVector().set(0.93634, 0.30902, 0.16667), new MutVector().set(0.93634, -0.30902, 0.16667), new MutVector().set(0.93417, 0.0, 0.35682), new MutVector().set(-0.74536, 0.0, 0.66667), new MutVector().set(-0.93634, -0.30902, 0.16667), new MutVector().set(-0.93634, 0.30902, 0.16667), new MutVector().set(-0.93417, 0.0, 0.35682), new MutVector().set(-0.74536, 0.0, -0.66667), new MutVector().set(-0.93634, 0.30902, -0.16667), new MutVector().set(-0.93634, -0.30902, -0.16667), new MutVector().set(-0.93417, 0.0, -0.35682), new MutVector().set(0.0, -0.66667, -0.74536), new MutVector().set(0.30902, -0.16667, -0.93634), new MutVector().set(-0.30902, -0.16667, -0.93634), new MutVector().set(0.0, -0.35682, -0.93417), new MutVector().set(0.26967, -0.76967, -0.57869), new MutVector().set(0.76967, -0.57869, -0.26967), new MutVector().set(0.57869, -0.26967, -0.76967), new MutVector().set(0.57735, -0.57735, -0.57735), new MutVector().set(0.16667, -0.93634, -0.30902), new MutVector().set(0.16667, -0.93634, 0.30902), new MutVector().set(0.66667, -0.74536, 0.0), new MutVector().set(0.35682, -0.93417, 0.0), new MutVector().set(0.26967, -0.76967, 0.57869), new MutVector().set(0.57869, -0.26967, 0.76967), new MutVector().set(0.76967, -0.57869, 0.26967), new MutVector().set(0.57735, -0.57735, 0.57735), new MutVector().set(0.0, -0.66667, 0.74536), new MutVector().set(-0.30902, -0.16667, 0.93634), new MutVector().set(0.30902, -0.16667, 0.93634), new MutVector().set(0.0, -0.35682, 0.93417), new MutVector().set(-0.26967, -0.76967, 0.57869), new MutVector().set(-0.76967, -0.57869, 0.26967), new MutVector().set(-0.57869, -0.26967, 0.76967), new MutVector().set(-0.57735, -0.57735, 0.57735), new MutVector().set(-0.16667, -0.93634, -0.30902), new MutVector().set(-0.66667, -0.74536, 0.0), new MutVector().set(-0.16667, -0.93634, 0.30902), new MutVector().set(-0.35682, -0.93417, 0.0), new MutVector().set(-0.26967, -0.76967, -0.57869), new MutVector().set(-0.57869, -0.26967, -0.76967), new MutVector().set(-0.76967, -0.57869, -0.26967), new MutVector().set(-0.57735, -0.57735, -0.57735));
    private static final double SIZE = 60.0;

    public GrenadeBullet(Vector pos, Vector speed, double weight, Machine machine) {
        super(pos, speed, weight, 3.0f, machine);
    }

    @Override
    protected boolean hit(RayCast.CastResult r, Model world, EntityParent parent) {
        parent.add(new Explode(r.point, 60.0f, 0.9f));
        parent.add(new Sound(SoundEnum.BOOM, r.point, 1.0f));
        MutVector center = new MutVector().set(r.point).add(this.getSpeed(), -0.1);
        VECTOR.stream().forEach(v -> {
            WorldObject obj;
            RayCast.CastResult r2 = new RayCast(center, (Vector)v, 60.0).cast(world);
            if (r2 != null && (obj = (WorldObject)r2.shape.getOwner()) != null && obj instanceof PhysicsObject) {
                double energy = 0.835 + 0.135 * r2.dist;
                ((PhysicsObject)obj).addForce(new Force(r2.point, new MutVector().set(r2.getNormal()).resize(-energy)));
                if (obj instanceof Part) {
                    this.hit();
                    Block block = ((Part)obj).getBlockByShape(r2.shape);
                    if (block != null) {
                        block.getMachine().damage(energy * 1.5 * 0.7);
                        block.damagePropagation(energy * 1.5 * 0.3);
                    }
                }
            }
        });
        return true;
    }
}

