/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;

public class Flag
extends Entity {
    private final Machine machine;

    public Flag(Machine machine) {
        super(Entity.Type.FLAG);
        this.machine = machine;
    }

    public Flag(int id) {
        super(id, Entity.Type.FLAG);
        this.machine = null;
    }

    @Override
    public void update(Model world, EntityParent parent) {
        this.pos.set(this.machine.getRootPart().getCenter());
    }

    @Override
    public boolean isEnable() {
        return this.machine.getRemainEndurance() <= 0.0;
    }

    @Override
    public Model getModel() {
        ModelGroup m = new ModelGroup();
        BoxShape b = new BoxShape(1.0f, 25.0f, 1.0f, TextureEnum.WHITE.getAsInfo());
        b.setColor(ColorEnum.MAP_ORANGE.getRgba());
        b.moveP(Vector.Y_AXIS, 12.5);
        BoxShape b2 = new BoxShape(16.0f, 10.0f, 0.5f, TextureEnum.WHITE.getAsInfo());
        b2.moveP(Vector.Y_AXIS, 19.0);
        b2.moveP(Vector.X_AXIS, 8.0);
        m.addModels(b, b2);
        m.moveP(this.pos);
        return m;
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
    }

    @Override
    protected Entity clone(int id) {
        return new Flag(id);
    }
}

