/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.model.IcosahedronShape;

public class Explode
extends Entity {
    private float size;
    private float life;

    public Explode(Vector pos, float size, float life) {
        super(Entity.Type.EXPLODE);
        this.pos.set(pos);
        this.size = size;
        this.life = life;
    }

    public Explode(int id) {
        super(id, Entity.Type.EXPLODE);
    }

    @Override
    public void update(Model world, EntityParent parent) {
        this.life = (float)((double)this.life - 0.016666666666666666);
    }

    @Override
    public boolean isEnable() {
        return this.life > 0.0f;
    }

    @Override
    public Model getModel() {
        IcosahedronShape m = new IcosahedronShape(this.size, TextureEnum.WHITE.getAsInfo());
        m.setColor(ColorEnum.PURPLE.getTransparentRgba());
        m.moveP(this.pos);
        return m;
    }

    @Override
    public final void read(ObjectInputStream s) throws IOException {
        this.size = s.readFloat();
    }

    @Override
    public final void write(ObjectOutputStream s) throws IOException {
        s.writeFloat(this.size);
    }

    @Override
    protected final Entity clone(int id) {
        Explode e = new Explode(id);
        e.size = this.size;
        return e;
    }
}

