/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import net.comp_lot.craftalos.game.entity.Bullet;
import net.comp_lot.craftalos.game.entity.BulletPredict;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.game.entity.Explode;
import net.comp_lot.craftalos.game.entity.Flag;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;

public abstract class Entity
implements Cloneable,
FastSerializable {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final int id;
    private final Type type;
    protected final MutVector pos = new MutVector();

    protected Entity(Type type) {
        this(nextId.getAndIncrement(), type);
    }

    protected Entity(int id, Type type) {
        this.id = id;
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public Vector getPos() {
        return this.pos;
    }

    public abstract void update(Model var1, EntityParent var2);

    public abstract boolean isEnable();

    public abstract Model getModel();

    protected abstract Entity clone(int var1);

    public void copy(Entity e) {
        this.pos.set(e.getPos());
    }

    public final Entity clone() {
        Entity e = this.clone(this.id);
        e.pos.set(this.getPos());
        return e;
    }

    public final boolean equals(Object o) {
        if (o == null || !(o instanceof Entity)) {
            return false;
        }
        return this.id == ((Entity)o).id;
    }

    public final int hashCode() {
        return this.id;
    }

    public static Entity readEntity(ObjectInputStream s) throws IOException {
        int id = s.readInt();
        Type type = Type.values()[s.readInt()];
        Entity e = null;
        switch (type) {
            case BULLET: {
                e = new Bullet(id);
                break;
            }
            case EXPLODE: {
                e = new Explode(id);
                break;
            }
            case FLAG: {
                e = new Flag(id);
                break;
            }
            case SOUND: {
                e = new Sound(id);
                break;
            }
            case BULLET_PREDICT: {
                e = new BulletPredict(id);
                break;
            }
            default: {
                throw new IOException("unknown entity: " + String.valueOf((Object)type));
            }
        }
        e.pos.read(s);
        e.read(s);
        return e;
    }

    public final void writeEntity(ObjectOutputStream s) throws IOException {
        s.writeInt(this.id);
        s.writeInt(this.type.ordinal());
        this.pos.write(s);
        this.write(s);
    }

    protected static enum Type {
        BULLET,
        EXPLODE,
        FLAG,
        SOUND,
        BULLET_PREDICT;

    }
}

