/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.phisics.PhysicsParent;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.model.BoxShape;

public class BulletPredict
extends Entity {
    private final List<MutVector> speedBuf;
    private final MutVector speed = new MutVector();
    private boolean enable = true;
    private int parentId = -1;

    public BulletPredict(Machine machine) {
        super(Entity.Type.BULLET_PREDICT);
        this.parentId = machine.getModel().id;
        this.speedBuf = new LinkedList<MutVector>();
    }

    public BulletPredict(int id) {
        super(id, Entity.Type.BULLET_PREDICT);
        this.speedBuf = null;
    }

    @Override
    public void update(Model world, EntityParent parent) {
    }

    public void set(Vector pos, Vector speed) {
        this.pos.set(pos);
        MutVector v = this.speedBuf.size() >= 4 ? this.speedBuf.remove(0) : new MutVector();
        this.speedBuf.add(v.set(speed));
        this.speed.set(Vector.ZERO);
        this.speedBuf.stream().forEach(s -> {
            MutVector mutVector = this.speed.add((Vector)s);
        });
        this.speed.scale(1.0 / (double)this.speedBuf.size());
    }

    public int getParentId() {
        return this.parentId;
    }

    public void disable() {
        this.enable = false;
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public Model getModel() {
        ModelGroup m = new ModelGroup();
        MutVector pos = new MutVector().set(this.pos);
        MutVector speed = new MutVector().set(this.speed);
        int i = 0;
        while (i < 10) {
            speed.add(PhysicsParent.GRAVITY_FORCE, 0.15);
            speed.scale(0.9999);
            pos.add(speed);
            ++i;
        }
        MutVector oldPos = new MutVector().set(pos);
        int i2 = 0;
        while (i2 < 1990) {
            speed.add(PhysicsParent.GRAVITY_FORCE, 0.15);
            speed.scale(0.9999);
            pos.add(speed);
            if (i2 % 30 == 0) {
                MutVector v = new MutVector().set(oldPos, pos);
                BoxShape b = new BoxShape(0.5f, 0.5f, (float)v.getSize(), TextureEnum.WHITE.getAsInfo());
                b.setColor(-103);
                b.setOpaque(false);
                double y = Vector.angle(Vector.Z_AXIS, new MutVector().set(v).toOrthogonal(Vector.Y_AXIS), Vector.Y_AXIS);
                v.rotate(Vector.Y_AXIS, -y);
                double x = Vector.angle(Vector.Z_AXIS, v, Vector.X_AXIS);
                b.rotateP(Vector.ZERO, Vector.X_AXIS, x);
                b.rotateP(Vector.ZERO, Vector.Y_AXIS, y);
                b.moveP(MutVector.iDivision(pos, oldPos, 1.0, 1.0));
                m.addModels(b);
                oldPos.set(pos);
            }
            ++i2;
        }
        return m;
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
        this.speed.read(s);
        this.parentId = s.readInt();
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
        this.speed.write(s);
        s.writeInt(this.parentId);
    }

    @Override
    public void copy(Entity e) {
        super.copy(e);
        BulletPredict bp = (BulletPredict)e;
        this.speed.set(bp.speed);
        this.parentId = bp.parentId;
    }

    @Override
    protected Entity clone(int id) {
        return new BulletPredict(id);
    }
}

