/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.craftalos.game.ColorEnum;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.TextureEnum;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.entity.EntityParent;
import net.comp_lot.craftalos.game.entity.Explode;
import net.comp_lot.craftalos.game.entity.Sound;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.phisics.Force;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.PhysicsParent;
import net.comp_lot.craftalos.phisics.WorldObject;
import net.comp_lot.craftalos.sound.SoundEnum;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.model.BoxShape;
import net.comp_lot.glui.model.utils.RayCast;

public class Bullet
extends Entity {
    private final MutVector speed = new MutVector();
    private final double weight;
    private float size;
    private int life;
    private final Machine machine;

    public Bullet(Vector pos, Vector speed, double weight, float size, Machine machine) {
        super(Entity.Type.BULLET);
        this.machine = machine;
        this.pos.set(pos);
        this.speed.set(speed);
        this.weight = weight;
        this.size = size;
        this.life = 1200;
    }

    public Bullet(int id) {
        super(id, Entity.Type.BULLET);
        this.machine = null;
        this.weight = 0.0;
    }

    @Override
    public Model getModel() {
        BoxShape m = new BoxShape(this.size, this.size, this.size, TextureEnum.WHITE.getAsInfo());
        m.setColor(ColorEnum.BLACK.getRgba());
        m.moveP(this.pos);
        return m;
    }

    protected boolean hit(RayCast.CastResult r, Model world, EntityParent parent) {
        parent.add(new Explode(r.point, 1.25f, 0.45f));
        parent.add(new Sound(SoundEnum.HIT, r.point, 1.0f));
        WorldObject obj = (WorldObject)r.shape.getOwner();
        if (obj != null && obj instanceof PhysicsObject) {
            Block block;
            double energy = this.getKineticEnergy(new MutVector().set(this.speed).add(((PhysicsObject)r.shape.getOwner()).getMove(r.point), -0.5));
            Block block2 = block = obj instanceof Part ? ((Part)obj).getBlockByShape(r.shape) : null;
            if (block != null) {
                this.hit();
                double whole = energy * 1.5 * 0.7;
                double single = energy * 1.5 * 0.3;
                single = block.damage(single);
                if (single > 0.0) {
                    double remain = (whole + single) / 1.5;
                    ((PhysicsObject)obj).addForce(new Force(r.point, new MutVector().set(this.speed).resize(energy - remain)));
                    this.speed.resize(Math.sqrt(remain / this.weight));
                    return false;
                }
                ((PhysicsObject)obj).addForce(new Force(r.point, new MutVector().set(this.speed).resize(energy)));
                block.getMachine().damage(whole);
            } else {
                ((PhysicsObject)obj).addForce(new Force(r.point, new MutVector().set(this.speed).resize(energy)));
            }
        }
        return true;
    }

    public Vector getSpeed() {
        return this.speed;
    }

    public double getKineticEnergy() {
        return this.getKineticEnergy(this.speed);
    }

    public double getKineticEnergy(Vector speed) {
        return this.weight * speed.getSize() * speed.getSize();
    }

    @Override
    public void update(Model world, EntityParent parent) {
        RayCast.CastResult r = new RayCast(this.pos, this.speed, this.speed.getSize()).cast(world);
        if (r != null) {
            if (this.hit(r, world, parent)) {
                this.life = 0;
            }
            return;
        }
        this.speed.add(PhysicsParent.GRAVITY_FORCE, 0.15);
        this.speed.scale(1.0 - 5.0E-4 / Math.sqrt(this.weight));
        this.pos.add(this.speed);
        --this.life;
    }

    protected void hit() {
        this.machine.print("*");
    }

    @Override
    public final void read(ObjectInputStream s) throws IOException {
        this.size = s.readFloat();
    }

    @Override
    public final void write(ObjectOutputStream s) throws IOException {
        s.writeFloat(this.size);
    }

    @Override
    public final boolean isEnable() {
        return this.life > 0;
    }

    @Override
    protected final Entity clone(int id) {
        Bullet b = new Bullet(id);
        b.size = this.size;
        return b;
    }
}

