/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import java.awt.Color;
import net.comp_lot.glui.model.TextureInfo;

public enum TextureEnum {
    WHITE(0, 0, 0xFFFFFF),
    FRAME(0, 1, 0xFFFFFF),
    FUNCTIONAL(2, 0, 0xFFFFFF),
    FUNCTIONAL_MOTOR(2, 1, 0xFFFFFF),
    FUNCTIONAL_SUPER_MOTOR(3, 5, 0xFFFFFF),
    FUNCTIONAL_LIGHT(2, 2, 0xFFFFFF),
    FUNCTIONAL_MOUSE(2, 3, 0xFFFFFF),
    FUNCTIONAL_CAMERA(2, 4, 0xFFFFFF),
    FUNCTIONAL_HORIZONTAL(2, 5, 0xFFFFFF),
    FUNCTIONAL_FCS(3, 0, 0xFFFFFF),
    FUNCTIONAL_CORE_SIDE(3, 2, 0xFFFFFF),
    FUNCTIONAL_CORE_EDGE(3, 3, 0xFFFFFF),
    FUNCTIONAL_LINK(3, 4, 0xFFFFFF),
    FUNCTIONAL_DISTANCE(1, 0, 0xFFFFFF),
    FUNCTIONAL_SPEED(1, 1, 0xFFFFFF),
    WEAPON(4, 0, 0xFFFFFF),
    WEAPON_MUZZLE(4, 1, 0xFFFFFF),
    WEAPON_MUZZLE2(4, 2, 0xFFFFFF),
    WEAPON_RIFLE(4, 3, 0xFFFFFF),
    WEAPON_GRENADE(4, 4, 0xFFFFFF),
    WEAPON_RAIL(4, 5, 0xFFFFFF),
    UI_GARAGE_ADD(3, 6, 0xFFFFFF),
    UI_EDIT_CENTER(2, 6, 0xFFFFFF),
    UI_CLIENT_CENTER(2, 7, 0xFFFFFF),
    UI_CLIENT_CENTER_HIT(3, 7, 0xFFFFFF),
    UI_BUTTON(0, 7, 0xFFFFFF),
    UI_TAB_BUTTON_V(0, 6, 0xFFFFFF),
    UI_TAB_BUTTON_H(0, 5, 0xFFFFFF),
    UI_RIGHT_BOTTOM(1, 7, 0xFFFFFF),
    UI_LEFT_TOP(1, 6, 0xFFFFFF),
    UI_WINDOW(1, 5, 0xFFFFFF),
    UI_CLEAR(7, 7, 0xFFFFFF),
    UI_BACKGROUND(6, 7, 0xFFFFFF),
    UI_BAG_OPEN(6, 6, 0xFFFFFF),
    UI_BAG_CLOSE(7, 6, 0xFFFFFF),
    UI_GABAGE_OPEN(6, 5, 0xFFFFFF),
    UI_GABAGE_CLOSE(7, 5, 0xFFFFFF),
    MISSION_MAP(7, 2, 0xFFFFFF);

    private final int x;
    private final int y;
    private final Color color;

    private TextureEnum(int x, int y, int rgb) {
        this.x = x;
        this.y = y;
        this.color = new Color(rgb);
    }

    public double dist(Color c) {
        return TextureEnum.dist(this.color.getRed() - c.getRed(), this.color.getGreen() - c.getGreen(), this.color.getBlue() - c.getBlue());
    }

    private static double dist(double r, double g, double b) {
        return r * r + g * g + b * b;
    }

    public TextureInfo getAsInfo() {
        return new TextureInfo(0, this.x * 128, this.y * 128, 128, 128);
    }
}

