/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.system.World;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.utils.RayCast;

class Restarter {
    private final PhysicsObject object;
    private final Model model;
    private final World world;
    private final MutVector restartPlace = new MutVector();
    private final MutVector restartRotate = new MutVector();
    private Vector[] restartPlaces;
    private Vector[] restartRotates;

    public Restarter(PhysicsObject object, World world) {
        this.object = object;
        this.model = object.getModel();
        this.world = world;
    }

    public void setRestartPlace(Vector place, Vector rotate) {
        MutVector pos = new MutVector().set(place).add(Vector.Y_AXIS, 16.0);
        RayCast cast = new RayCast(pos, new MutVector().set(0.0, -1.0, 0.0), 128.0);
        RayCast.CastResult r = cast.cast(this.world.getMapObject().getModel());
        if (r != null) {
            pos.set(r.point).add(Vector.Y_AXIS, 16.0);
        } else {
            pos.set(place);
        }
        this.restartPlace.set(pos);
        this.restartRotate.set(rotate);
    }

    public void setRestartPlaces(Vector[] places, Vector[] rotates) {
        this.restartPlaces = places;
        this.restartRotates = rotates;
    }

    public void restart() {
        this.object.stopMotion();
        this.model.moveToP(this.restartPlace);
        this.model.rotateToP(this.restartPlace, this.restartRotate, this.restartRotate.getSize());
        double step = 0.75;
        int i = 0;
        while (i < 64 && step > 0.05) {
            this.model.moveP(Vector.Y_AXIS, -step);
            this.model.callConfirmCoordinate();
            this.model.setBound();
            if (!this.world.getMapObject().getModel().touchTest(this.model).isEmpty()) {
                this.model.moveP(Vector.Y_AXIS, step);
                step *= 0.5;
            }
            ++i;
        }
        this.model.moveP(Vector.Y_AXIS, 1.0);
        this.model.callConfirmCoordinate();
        this.model.setBound();
    }

    public void setRestartPlace() {
        double minDist = Double.MAX_VALUE;
        MutVector dist = new MutVector();
        int i = 0;
        while (i < this.restartPlaces.length) {
            dist.set(this.model.getCoordinateSystem().getCenter(), this.restartPlaces[i]);
            if (dist.getSize() < minDist) {
                minDist = dist.getSize();
                this.setRestartPlace(this.restartPlaces[i], this.restartRotates[i]);
            }
            ++i;
        }
    }
}

