/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.comp_lot.craftalos.game.ColorSettable;
import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.MachineModel;
import net.comp_lot.craftalos.game.MachineProperty;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.parts.LinkBlock;
import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.phisics.PhysicsProperty;
import net.comp_lot.glui.amount.Matrix;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.Shape;
import net.comp_lot.glui.model.utils.TouchInfo;

public final class Part
extends PhysicsObject
implements MachineProperty,
ColorSettable {
    private final List<Block> blockList = new ArrayList<Block>();
    private final ModelGroup blockModel = new ModelGroup();
    private final Machine machine;
    private Part parent;
    private boolean collidableWithParent = true;
    private Vector center = new MutVector();
    private int weight;
    private Matrix tensor;
    private MutVector singleCenter = new MutVector();
    private int singleWeight;

    public Part(Machine machine) {
        super(new ModelGroup());
        ((ModelGroup)this.getModel()).addModels(this.getBlockModel());
        this.machine = machine;
    }

    public Part(Machine machine, MachineModel machineModel) {
        super(machineModel);
        this.machine = machine;
    }

    public Machine getMachine() {
        return this.machine;
    }

    protected void addBlock(Block block) {
        this.blockList.add(block);
        this.blockModel.addModels(block.getModel());
    }

    public void addBlocks(Block ... blocks) {
        Block[] blockArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            Block b = blockArray[n2];
            this.addBlock(b);
            ++n2;
        }
    }

    public void removeBlock(Block block) {
        this.blockList.remove(block);
        this.blockModel.removeModel(block.getModel());
    }

    public void addPart(Part child) {
        this.addChild(child);
        child.setParent(this);
    }

    public void removePart(Part child) {
        this.removeChild(child);
    }

    private void setParent(Part parent) {
        this.parent = parent;
    }

    public List<Block> getAllBlocks() {
        return this.blockList;
    }

    public Model getBlockModel() {
        return this.blockModel;
    }

    public Block getBlockByShape(Shape shape) {
        for (Block b : this.getAllBlocks()) {
            if (!shape.isParent(b.getModel())) continue;
            return b;
        }
        return null;
    }

    public void setColorType(boolean opaque, boolean dark) {
        this.blockList.stream().forEach(b -> b.setColorType(opaque, dark));
    }

    public void setColorTypeRec(boolean opaque, boolean dark) {
        this.setColorType(opaque, dark);
        this.getChildren().stream().forEach(m -> ((Part)m).setColorTypeRec(opaque, dark));
    }

    public List<TouchInfo> partsTouchTest(Part p) {
        if (this.parent == p && !this.collidableWithParent || p.parent == this && !p.collidableWithParent) {
            return null;
        }
        if (!this.getBlockModel().getBound().crossing(p.getBlockModel().getBound())) {
            return null;
        }
        ArrayList<TouchInfo> list = new ArrayList<TouchInfo>();
        this.getAllBlocks().stream().forEach(c -> p.getAllBlocks().stream().forEach(c2 -> c.getModel().touchTest(c2.getModel(), list)));
        list.removeIf(t -> t.getVec().getSize() < 0.15);
        list.stream().filter(t -> t.getVec().getSize() < 0.3).forEach(t -> {
            TouchInfo touchInfo = t.resize((t.getVec().getSize() - 0.15) * 2.0);
        });
        return list;
    }

    public void setCollidableWithParent(boolean collidability) {
        this.collidableWithParent = collidability;
    }

    @Override
    public boolean hasDomesticCollide() {
        return true;
    }

    @Override
    public int getSingleWeight() {
        return this.singleWeight;
    }

    @Override
    public Vector getSingleCenter() {
        return this.singleCenter;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public Vector getCenter() {
        return this.center;
    }

    @Override
    public Matrix getTensor() {
        return this.tensor;
    }

    @Override
    protected void computeMove() {
        if (this.blockList.isEmpty() || this.isAlive()) {
            super.computeMove();
        }
    }

    @Override
    protected void computePhisics() {
        this.blockList.stream().filter(b -> b instanceof LinkBlock).forEach(b -> ((LinkBlock)b).link());
        super.computePhisics();
    }

    @Override
    public void computeCenter() {
        this.singleWeight = Part.calcWeightAndCenter(this.singleCenter, this.getAllBlocks());
        MutVector center = new MutVector();
        this.weight = Part.calcWeightAndCenter(center, this.getChildren());
        if (this.singleWeight > 0) {
            this.center = MutVector.iDivision(this.singleCenter, center, this.weight, this.singleWeight);
            this.weight += this.singleWeight;
        } else {
            this.center = center;
        }
        this.tensor = new Matrix(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Consumer<PhysicsProperty> c = gc -> {
            this.tensor.add(gc.getTensor());
            MutVector r = new MutVector().set(this.getCenter(), gc.getCenter());
            this.tensor.add(PhysicsObject.getOffsetTensor(r, gc.getWeight()));
        };
        this.getChildren().stream().forEach(p -> c.accept((PhysicsProperty)p));
        this.getAllBlocks().stream().filter(b -> b.isAlive()).forEach(b -> c.accept((PhysicsProperty)b));
    }

    private static int calcWeightAndCenter(MutVector dst, List<? extends PhysicsProperty> list) {
        int weight = 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (PhysicsProperty physicsProperty : list) {
            physicsProperty.computeCenter();
            if (!((MachineProperty)((Object)physicsProperty)).isAlive()) continue;
            int w = physicsProperty.getWeight();
            Vector c = physicsProperty.getCenter();
            weight += w;
            x += c.getX() * (double)w;
            y += c.getY() * (double)w;
            z += c.getZ() * (double)w;
        }
        if (weight > 0) {
            dst.set(x / (double)weight, y / (double)weight, z / (double)weight);
        } else {
            dst.set(Vector.ZERO);
        }
        return weight;
    }

    @Override
    public void clear() {
        super.clear();
        this.blockList.clear();
        this.blockModel.clearChildren();
        ((ModelGroup)this.getModel()).addModels(this.blockModel);
    }

    @Override
    public double getInitialEndurance() {
        return this.blockList.stream().map(b -> b.getInitialEndurance()).reduce(0.0, (a, b) -> a + b);
    }

    @Override
    public void setTex(int rgba) {
        this.getChildren().stream().forEach(c -> ((ColorSettable)((Object)c)).setTex(rgba));
        this.getAllBlocks().stream().filter(b -> b instanceof ColorSettable).forEach(b -> ((ColorSettable)((Object)b)).setTex(rgba));
    }

    public static void replaceAllChildren(Part src, Part dst) {
        src.getChildren().stream().forEach(p -> dst.addPart((Part)p));
        src.getAllBlocks().stream().forEach(b -> dst.addBlocks((Block)b));
        src.clear();
    }

    @Override
    public void resetEndurance() {
        this.getAllBlocks().stream().forEach(b -> b.resetEndurance());
        this.getChildren().stream().forEach(p -> ((Part)p).resetEndurance());
        this.singleWeight = this.getAllBlocks().stream().mapToInt(b -> b.getWeight()).sum();
        this.weight = this.singleWeight + this.getChildren().stream().mapToInt(p -> p.getWeight()).sum();
    }

    @Override
    public double getRemainEndurance() {
        return this.getAllBlocks().stream().map(b -> b.getRemainEndurance()).reduce(0.0, (a, b) -> a + b);
    }

    @Override
    public void setEndurance(double endurance) {
        double scale = endurance / this.getRemainEndurance();
        this.getAllBlocks().stream().forEach(b -> b.setEndurance(b.getRemainEndurance() * scale));
    }

    public void destroy() {
        this.getAllBlocks().stream().filter(b -> b.isAlive()).forEach(b -> {
            double d = b.damage(b.getRemainEndurance());
        });
    }
}

