/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import net.comp_lot.craftalos.game.Machine;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.model.ModelGroup;
import net.comp_lot.glui.model.utils.Bound;

public class MachineChecker {
    private static final int MAX_SIZE = 72;
    private final Machine machine;
    private String message = "";
    private boolean[][][] map;

    public MachineChecker(Machine m) {
        this.machine = m;
    }

    public boolean check(Model block) {
        this.map = new boolean[72][72][72];
        this.checkAndSet(this.machine.getModel());
        return this.checkAndSet(block);
    }

    public boolean check() {
        this.message = "";
        this.map = new boolean[72][72][72];
        this.machine.getModel().callConfirmCoordinate();
        this.machine.getModel().setBound();
        if (!this.checkAndSet(this.machine.getModel())) {
            return false;
        }
        if (!this.checkFloating()) {
            return false;
        }
        if (!this.checkParts(null, this.machine.getRootPart())) {
            return false;
        }
        for (FunctionalBlock fb : this.machine.getFunctionalBlocks()) {
            ConnectionBlock cb;
            if (!(fb instanceof ConnectionBlock) || this.checkParts(cb = (ConnectionBlock)fb, cb.getChild())) continue;
            return false;
        }
        return true;
    }

    private boolean checkParts(ConnectionBlock c, Part p) {
        this.map = new boolean[72][72][72];
        if (c != null) {
            this.checkAndSet(c.getModel());
        }
        for (Block b : p.getAllBlocks()) {
            this.checkAndSet(b.getModel());
        }
        return this.checkFloating();
    }

    private boolean checkFloating() {
        boolean first = true;
        int x = 0;
        while (x < 72) {
            int y = 0;
            while (y < 72) {
                int z = 0;
                while (z < 72) {
                    if (this.map[x][y][z]) {
                        if (first) {
                            first = false;
                            this.deleteRec(x, y, z);
                        } else {
                            this.message = StringManager.lang.machineErrorFloatingBlock();
                            return false;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    private void deleteRec(int x, int y, int z) {
        if (x < 0 || x >= 72 || y < 0 || y >= 72 || z < 0 || z >= 72) {
            return;
        }
        if (!this.map[x][y][z]) {
            return;
        }
        this.map[x][y][z] = false;
        this.deleteRec(x - 1, y, z);
        this.deleteRec(x + 1, y, z);
        this.deleteRec(x, y - 1, z);
        this.deleteRec(x, y + 1, z);
        this.deleteRec(x, y, z - 1);
        this.deleteRec(x, y, z + 1);
    }

    private boolean checkAndSet(Model m) {
        if (m instanceof ModelGroup) {
            for (Model c : ((ModelGroup)m).getAllChildren()) {
                if (this.checkAndSet(c)) continue;
                return false;
            }
        } else {
            Bound b = m.getBound();
            int x = (int)Math.round(b.getMinX());
            while (x < (int)Math.round(b.getMaxX())) {
                int y = (int)Math.round(b.getMinY());
                while (y < (int)Math.round(b.getMaxY())) {
                    int z = (int)Math.round(b.getMinZ());
                    while (z < (int)Math.round(b.getMaxZ())) {
                        if (!this.checkAndSet(x, y, z)) {
                            return false;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return true;
    }

    private boolean checkAndSet(int x, int y, int z) {
        if ((x += 36) < 0 || x >= 72 || y < 0 || y >= 72 || (z += 36) < 0 || z >= 72) {
            this.message = StringManager.lang.machineErrorOutOfRange();
            return false;
        }
        if (this.map[x][y][z]) {
            this.message = StringManager.lang.machineErrorBlockInterfere();
            return false;
        }
        this.map[x][y][z] = true;
        return true;
    }

    public String getMessage() {
        return this.message;
    }
}

