/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.comp_lot.craftalos.game.ColorSettable;
import net.comp_lot.craftalos.game.Flipper;
import net.comp_lot.craftalos.game.GameCamera;
import net.comp_lot.craftalos.game.MachineModel;
import net.comp_lot.craftalos.game.MachineProperty;
import net.comp_lot.craftalos.game.MachineState;
import net.comp_lot.craftalos.game.Part;
import net.comp_lot.craftalos.game.Restarter;
import net.comp_lot.craftalos.game.entity.Entity;
import net.comp_lot.craftalos.game.model.Block;
import net.comp_lot.craftalos.game.model.ConnectionBlock;
import net.comp_lot.craftalos.game.model.FunctionalBlock;
import net.comp_lot.craftalos.game.model.parts.CoreBlock;
import net.comp_lot.craftalos.lang.StringManager;
import net.comp_lot.craftalos.program.compiler.MachineProgram;
import net.comp_lot.craftalos.system.World;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;
import net.comp_lot.glui.system.OperationEvent;
import net.comp_lot.glui.system.utils.KeyStateManager;

public class Machine
implements MachineProperty,
ColorSettable {
    private final MachineModel model;
    private final Part machinePart;
    private List<FunctionalBlock> functionalBlocks = new ArrayList<FunctionalBlock>();
    private List<Part> allParts = new ArrayList<Part>();
    private World world;
    private boolean fixed = false;
    private boolean canRestart = true;
    private Restarter restarter;
    private Flipper flipper;
    private boolean action = false;
    private boolean fcsEnable = false;
    private final GameCamera camera = new GameCamera();
    private final MutVector cameraAxis = new MutVector();
    private OperationEvent.KeyState newKeyState = new OperationEvent.KeyState();
    private KeyStateManager keyState = new KeyStateManager();
    private MachineProgram program;
    private Consumer<String> printer = s -> {};
    private Consumer<String> globalPrinter = s -> {};
    private MachineState state = new MachineState(-1.0, 100.0);

    public Machine() {
        this.model = new MachineModel(this);
        this.machinePart = (Part)this.model.getOwner();
        this.functionalBlocks.add(null);
    }

    public Model getModel() {
        return this.model;
    }

    public Part getMachinePart() {
        return this.machinePart;
    }

    public Part getRootPart() {
        return (Part)this.getMachinePart().getChildren().get(0);
    }

    public void addPart(Part p) {
        this.getMachinePart().addPart(p);
        this.allParts.add(p);
    }

    public void addMachinePart(Part p) {
        this.allParts.add(p);
    }

    public void removeMachinePart(Part p) {
        this.allParts.remove(p);
    }

    public void clearParts() {
        this.allParts.clear();
    }

    public List<Part> getAllParts() {
        return this.allParts;
    }

    public int countBlock() {
        return this.allParts.stream().map(p -> p.getAllBlocks().size()).reduce(0, (a, b) -> a + b);
    }

    public int countPart() {
        return this.allParts.size();
    }

    public int countWeight() {
        return this.allParts.stream().map(p -> p.getAllBlocks().stream().map(b -> b.getWeight()).reduce(0, (a, b) -> a + b)).reduce(0, (a, b) -> a + b);
    }

    public void setWorld(World world) {
        this.world = world;
        this.restarter = new Restarter(this.getMachinePart(), world);
        this.flipper = new Flipper(this.getMachinePart(), world);
    }

    public World getWorld() {
        return this.world;
    }

    public void addFunctionalBlocks(FunctionalBlock ... blocks) {
        FunctionalBlock[] functionalBlockArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionalBlock b = functionalBlockArray[n2];
            this.functionalBlocks.add(b);
            ++n2;
        }
    }

    public List<FunctionalBlock> getFunctionalBlocks() {
        return this.functionalBlocks;
    }

    public double getBlockValue(int index) {
        if (index == 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index > 0) {
            return this.functionalBlocks.get(index).getValueIfAlive();
        }
        return -this.functionalBlocks.get(-index).getValueIfAlive();
    }

    public void setBlockValue(int index, double value) {
        if (index == 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index > 0) {
            this.functionalBlocks.get(index).setValueIfAlive(value);
        } else {
            this.functionalBlocks.get(-index).setValueIfAlive(-value);
        }
    }

    public void setRestartPlace(Vector place, Vector rotate) {
        this.restarter.setRestartPlace(place, rotate);
    }

    public void setRestartPlaces(Vector[] places, Vector[] rotates) {
        this.restarter.setRestartPlaces(places, rotates);
    }

    public void setProgram(MachineProgram program) {
        this.program = program;
        program.setMachine(this);
    }

    public boolean getKeyState(OperationEvent.KeyCode key) {
        return this.keyState.getKeyState(key);
    }

    public boolean getKeyDown(OperationEvent.KeyCode key) {
        return this.keyState.getKeyDown(key);
    }

    public void setKeyState(OperationEvent.KeyState keyState) {
        this.newKeyState = keyState;
    }

    public void restart() {
        this.resetEndurance();
        this.resetEnergy();
        this.restarter.restart();
    }

    public void setCanRestart(boolean can) {
        this.canRestart = can;
        this.print("!restart:" + can);
    }

    public void frame() {
        this.state.endurance = this.getAllParts().parallelStream().map(p -> p.getRemainEndurance()).reduce(0.0, (a, b) -> a + b);
        if (this.world == null || this.fixed) {
            return;
        }
        this.destroyUnconnectedBlocks();
        this.functionalBlocks.stream().filter(b -> b != null).forEach(b -> b.update());
        this.keyState.set(this.newKeyState);
        if (this.getKeyState(OperationEvent.KeyCode.KEY_ENTER)) {
            if (this.canRestart) {
                if (this.getKeyDown(OperationEvent.KeyCode.KEY_ENTER)) {
                    this.resetPose();
                }
                this.restart();
            } else if (this.getKeyDown(OperationEvent.KeyCode.KEY_ENTER)) {
                this.print(StringManager.lang.mapRestartNotAvailable());
            }
        }
        if (this.getKeyState(OperationEvent.KeyCode.KEY_BACKSPACE)) {
            this.restarter.setRestartPlace();
        }
        if (this.getKeyDown(OperationEvent.KeyCode.KEY_Z)) {
            this.action = true;
        }
        this.flipper.update(this.getKeyDown(OperationEvent.KeyCode.KEY_F), this.getRemainEndurance() == 0.0 || this.canRestart && this.getKeyState(OperationEvent.KeyCode.KEY_ENTER));
        if (this.getRemainEndurance() > 0.0) {
            this.setCamera(this.getRootPart().getCenter(), null, null);
            this.state.energy += 1.66 - this.getEnergyUse();
            if (this.state.energy > 100.0) {
                this.resetEnergy();
            }
            this.fcsEnable = false;
            if (this.program != null) {
                this.program.run();
            }
        } else {
            this.functionalBlocks.stream().filter(b -> b != null).forEach(b -> b.setValueIfAlive(0.0));
        }
    }

    private void destroyUnconnectedBlocks() {
        this.getAllParts().stream().forEach(p -> p.getAllBlocks().stream().forEach(b -> b.setConnected(false)));
        this.functionalBlocks.stream().filter(b -> b != null).filter(b -> b instanceof CoreBlock).filter(b -> b.isAlive()).filter(b -> b.getPart() == this.getRootPart()).forEach(b -> b.setConnectedRec());
        this.getAllParts().stream().forEach(p -> p.getAllBlocks().stream().forEach(b -> b.destroyIfNotConnected()));
    }

    public void resetPose() {
        this.getAllParts().stream().filter(p -> p.getParent() != this.machinePart).forEach(p -> {
            p.getModel().moveToP(Vector.ZERO);
            p.getModel().rotateToP(Vector.ZERO, Vector.X_AXIS, 0.0);
            p.stopMotion();
        });
    }

    public void addEntity(Entity e) {
        this.world.addEntity(e);
    }

    public boolean isSolid() {
        return this.world == null || !this.world.isDamageEnable();
    }

    public boolean useEnergy(double energy) {
        return true;
    }

    @Override
    public double getInitialEndurance() {
        return this.allParts.stream().map(b -> b.getInitialEndurance()).reduce(0.0, (a, b) -> a + b);
    }

    @Override
    public double getRemainEndurance() {
        return this.state.endurance;
    }

    @Override
    public void setEndurance(double endurance) {
        double scale = endurance / this.getRemainEndurance();
        this.allParts.parallelStream().forEach(p -> p.setEndurance(p.getRemainEndurance() * scale));
    }

    @Override
    public void resetEndurance() {
        this.machinePart.resetEndurance();
        this.state.endurance = this.allParts.parallelStream().mapToDouble(p -> p.getRemainEndurance()).sum();
    }

    private void resetEnergy() {
        this.state.energy = 100.0;
    }

    public MachineState getState() {
        return this.state;
    }

    public boolean isFcsEnable() {
        return this.fcsEnable;
    }

    public void setFcsEnable(boolean fcsEnable) {
        this.fcsEnable = fcsEnable;
    }

    public void setCamera(Vector pos, Vector axis, Vector top) {
        this.camera.set(pos, axis, top);
    }

    public GameCamera getCamera() {
        return this.camera;
    }

    public void setCameraAxis(Vector axis) {
        this.cameraAxis.set(axis);
    }

    public MutVector setCameraAxis() {
        return this.cameraAxis;
    }

    public Vector getCameraAxis() {
        return this.cameraAxis;
    }

    public boolean getAction() {
        boolean rtn = this.action;
        this.action = false;
        return rtn;
    }

    public void print(String text) {
        this.printer.accept(text);
    }

    public void setPrinter(Consumer<String> printer) {
        this.printer = printer;
    }

    public void printGlobal(String text) {
        this.globalPrinter.accept(text);
    }

    public void setGlobalPrinter(Consumer<String> printer) {
        this.globalPrinter = printer;
    }

    @Override
    public int getWeight() {
        return this.countWeight();
    }

    @Override
    public void setTex(int rgba) {
        this.getRootPart().setTex(rgba);
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    private void setCollidability() {
        this.functionalBlocks.parallelStream().filter(b -> b instanceof ConnectionBlock).map(b -> (ConnectionBlock)b).forEach(c -> c.setCollidability());
    }

    public synchronized void damage(double damage) {
        if (this.isSolid()) {
            return;
        }
        double endurance = this.getAllParts().parallelStream().mapToDouble(p -> p.getRemainEndurance()).sum();
        if (endurance == 0.0) {
            return;
        }
        double baseEndurance = Math.max((endurance - damage) / endurance, 0.0);
        this.getAllParts().stream().forEach(p -> p.getAllBlocks().stream().forEach(b -> b.setEndurance(b.getRemainEndurance() * baseEndurance)));
    }

    public void initialize() {
        this.resetEndurance();
        this.getAllParts().parallelStream().forEach(p -> p.getAllBlocks().stream().forEach(b -> b.cacheParent()));
        this.getAllParts().parallelStream().forEach(p -> p.getAllBlocks().stream().forEach(block -> p.getAllBlocks().stream().filter(b -> b != block).forEach(b -> block.addIfAdjacent((Block)b))));
        this.getFunctionalBlocks().stream().filter(b -> b != null).filter(b -> b instanceof ConnectionBlock).map(b -> (ConnectionBlock)b).forEach(c -> c.getChild().getAllBlocks().stream().forEach(b -> {
            c.addIfAdjacent((Block)b);
            if (c.isAdjacent((Block)b)) {
                b.addIfAdjacent((Block)c);
            }
        }));
        this.setCollidability();
    }
}

