/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.comp_lot.glui.amount.FastSerializable;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;

public class GameCamera
implements FastSerializable {
    private boolean fixed = false;
    private final MutVector cameraPos = new MutVector();
    private final MutVector cameraAxis = new MutVector();
    private final MutVector cameraTop = new MutVector();

    public void set(Vector cameraPos, Vector cameraAxis, Vector cameraTop) {
        this.cameraPos.set(cameraPos);
        if (cameraAxis != null && cameraTop != null) {
            this.fixed = true;
            this.cameraAxis.set(cameraAxis);
            this.cameraTop.set(cameraTop);
        } else {
            this.fixed = false;
        }
    }

    public void set(GameCamera camera) {
        this.fixed = camera.fixed;
        this.cameraPos.set(camera.cameraPos);
        this.cameraAxis.set(camera.cameraAxis);
        this.cameraTop.set(camera.cameraTop);
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public Vector getCameraPos() {
        return this.cameraPos;
    }

    public Vector getCameraAxis() {
        return this.cameraAxis;
    }

    public Vector getCameraUp() {
        return this.cameraTop;
    }

    @Override
    public void read(ObjectInputStream s) throws IOException {
        this.fixed = s.readBoolean();
        this.cameraPos.read(s);
        if (this.fixed) {
            this.cameraAxis.read(s);
            this.cameraTop.read(s);
        }
    }

    @Override
    public void write(ObjectOutputStream s) throws IOException {
        s.writeBoolean(this.fixed);
        this.cameraPos.write(s);
        if (this.fixed) {
            this.cameraAxis.write(s);
            this.cameraTop.write(s);
        }
    }
}

