/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import net.comp_lot.craftalos.phisics.PhysicsObject;
import net.comp_lot.craftalos.system.World;
import net.comp_lot.glui.amount.MutVector;
import net.comp_lot.glui.amount.Vector;
import net.comp_lot.glui.model.Model;

class Flipper {
    private static final double RELOAD_TIME = -0.5;
    private final PhysicsObject object;
    private final Model model;
    private final World world;
    private double time = 0.0;
    private final MutVector pos = new MutVector();
    private final MutVector rot = new MutVector();
    private final MutVector startRot = new MutVector();
    private final MutVector targetRot = new MutVector();
    private final MutVector tempRot = new MutVector();

    public Flipper(PhysicsObject object, World world) {
        this.object = object;
        this.model = object.getModel();
        this.world = world;
    }

    public void update(boolean keyDown, boolean restart) {
        if (restart) {
            this.time = 0.0;
            return;
        }
        if (this.time > -0.5) {
            this.time = Math.max(this.time - 0.0033333333333333335, -0.5);
        }
        if (keyDown && this.time == -0.5) {
            this.time = 1.25;
            this.pos.set(this.model.getCoordinateSystem().getCenter()).add(Vector.Y_AXIS, 0.25);
            this.rot.set(this.model.getRotationMatrix().toRotVec());
            this.startRot.set(this.rot);
            this.targetRot.set(this.rot).toParallel(Vector.Y_AXIS);
        }
        if (this.time > 0.0) {
            this.model.moveToP(this.pos);
            this.model.rotateToP(this.pos, this.rot, this.rot.getSize());
            if (this.time > 1.0) {
                this.pos.add(Vector.Y_AXIS, 0.15000000000000002);
                this.model.moveToP(this.pos);
                this.model.callConfirmCoordinate();
                this.model.setBound();
                if (this.collide()) {
                    this.pos.add(Vector.Y_AXIS, -0.15000000000000002);
                }
            } else if (this.time > 0.5) {
                this.tempRot.set(MutVector.iDivision(this.targetRot, this.startRot, this.time - 0.5, 1.0 - this.time));
                this.model.rotateToP(this.pos, this.tempRot, this.tempRot.getSize());
                this.model.callConfirmCoordinate();
                this.model.setBound();
                if (!this.collide()) {
                    this.rot.set(this.tempRot);
                }
            } else {
                this.pos.add(Vector.Y_AXIS, -0.15000000000000002);
                this.model.moveToP(this.pos);
                this.model.callConfirmCoordinate();
                this.model.setBound();
                if (this.collide()) {
                    this.pos.add(Vector.Y_AXIS, 0.15000000000000002);
                }
            }
            this.model.moveToP(this.pos);
            this.model.rotateToP(this.pos, this.rot, this.rot.getSize());
            this.model.callConfirmCoordinate();
            this.model.setBound();
            this.object.stopMotion();
        }
    }

    private boolean collide() {
        return this.world.getObjects().parallelStream().anyMatch(o -> o != this.object && !o.getModel().touchTest(this.model).isEmpty());
    }
}

