/*
 * Decompiled with CFR 0.152.
 */
package net.comp_lot.craftalos.game;

import java.awt.Color;

public enum ColorEnum {
    WHITE(0xFFFFFF),
    BLACK(0x424242),
    RED(14761046),
    GREEN(7907844),
    BLUE(4881871),
    PURPLE(8078231),
    ORANGE(14773564),
    YELLOW(14724612),
    MAP_RED(14002902),
    MAP_GREEN(12112784),
    MAP_BLUE(10724054),
    MAP_LIGHT_BLUE(11455698),
    MAP_ORANGE(14336692),
    MAP_YELLOW(14605003);

    private final int rgba;
    private final int darkRgba;
    private final int transparentRgba;
    private final Color color;

    private ColorEnum(int rgb) {
        this.rgba = rgb << 8 | 0xFF;
        this.color = new Color(rgb);
        this.darkRgba = ColorEnum.darker(rgb);
        this.transparentRgba = ColorEnum.transparent(this.rgba);
    }

    public static int transparent(int rgba) {
        return rgba & 0xFFFFFF88;
    }

    public static int darker(int rgba) {
        Color color = new Color(rgba >> 8);
        return new Color(color.getRed() / 2, color.getGreen() / 2, color.getBlue() / 2).getRGB() << 8 | 0xFF;
    }

    public int getRgba() {
        return this.rgba;
    }

    public int getDarkRgba() {
        return this.darkRgba;
    }

    public int getTransparentRgba() {
        return this.transparentRgba;
    }

    public double dist(Color c) {
        return ColorEnum.dist(this.color.getRed() - c.getRed(), this.color.getGreen() - c.getGreen(), this.color.getBlue() - c.getBlue());
    }

    private static double dist(double r, double g, double b) {
        return r * r + g * g + b * b;
    }
}

